<!-- Interactive Movie Template created by Bergware International -->
<!-- Made for Ant Movie Cataglog http://www.antp.be/software      -->
<!-- Based on the template made by Twink beta version 0.8         -->
<!-- Last Update: 16 March 2008 - Version 0.91                    -->

//SYSTEM CHANGEABLES
 var formats=["Extended","Collapsed","Popup","Thumbnail","List"];
 var countries="countries.xml";   //Country ISO codes
 var database="movies.xml";       //Movie database in XML format
 var expiry=365;                  //Cookie validity in days
 var bracket1="[";                //Surrounding brackets
 var bracket2="]";
 var button1="[++]";              //Expand action
 var button2="[--]";              //Collapse action
 var all="[All]";                 //Name of ALL category
 var find="[Search]";             //Name of SEARCH category
 var hour="hour";                 //Local time naming
 var min="min";
 var sec="sec";
 var txt=[];                      //Text array (may be translated)
  txt[0]="Layout";
  txt[1]="Categories";
  txt[2]="No matching titles found";
  txt[3]="Page";
  txt[4]=" of ";

//SYSTEM CONSTANTS
 var letters='ABCDEFGHIJKLMNOPQRSTUVWXYZ';

//SYSTEM VARIABLES 
 var movies=null;                 //Array containing all titles
 var movie=null;                  //Individual title
 var categoryItem=null;           //Array of selectable categories
 var categoryList=null;           //Array of displayed categories
 var defaults=null;               //Holds default settings

 var startfrom;                   //Starting entry in list
 var sortdir;                     //Sort Ascending or Descending
 var column;                      //Column used for sorting
 var columns;                     //Total number of columns in table
 var rowindex;                    //Index number in selected category
 var xmlDoc;                      //XML file: layout
 var xmlISO;                      //XML file: country codes
 var xmlData;                     //XML file: database
 var empty;                       //Flag
 var expanded;                    //Flag
 var oldtip;                      //Flag
 
 var category;                    //Option in layout.xml, default value = all
 var pagesize;                    //Option in layout.xml, default value = 10 
 var sortkey;                     //Option in layout.xml, default value = none
 var searchkey;                   //Option in layout.xml, default value = Description
 var separator;                   //Option in layout.xml, default value = false

//STRING PROTOTYPES
 String.prototype.trim=function(){
   return this.replace(/(^\s*)|(\s*$)/g,'');
 }
 String.prototype.capitalize=function(){
   return this.charAt(0).toUpperCase()+this.substr(1);
 }
 String.prototype.linefeed=function(){
   return this.replace(/\|/g,'<br>');
 }
 String.prototype.sanitize=function(){
   return this.replace(/\|/g,'&#13;&#10;').replace(/\'/g,'&#39;').replace(/\"/g,'&#34;');
 }
 String.prototype.spaceOut=function(){
   return this.replace(/ /g,'');
 }
 String.prototype.spaceIn=function(){
   return this.replace(//g,' ');
 }
 String.prototype.set=function(s){
  return 'S'+this.toString()+(s>0?letters.charAt(s-1):'');
 }
 String.prototype.divider=function(){
   return this.replace(/ \/ /g,", ");
 }

//GENERAL FUNCTIONS
 function isLetter(char,exclude){
   return letters.indexOf(char.toUpperCase())!=-1 && exclude.indexOf(char.toUpperCase())==-1;
 }
 function isNumber(n){
   return !isNaN(+n);
 }
 function cast(s){
   return s?(isNaN(+s)==true?s.toLowerCase():+s):"";
 } 
 function asc(c){
   return c.charCodeAt(0);
 }
 function chr(c){
   return String.fromCharCode(c);
 }
 function int(x){
   return parseInt(x);
 }
 function page(x){
   var p=x/pagesize;
   return int(p+((p-int(p))==0?0:1));
 }
 function totalPages(){
   return page(movies[category].length);
 }
 function currentPage(){
   return (pagesize>0?totalPages()-page(movies[category].length-startfrom-pagesize):1);
 }
 function dToggle(x,y){
   document.getElementById(x).style.display=(y==-1 && document.getElementById(x).style.display=="" || y==0?"none":"");
 }
 function getWindowWidth(){
   return window.innerWidth?window.innerWidth:document.body.clientWidth;
 }

//HELPER FUNCTIONS
 function round(number){
   return Math.round(number)||0;
 }
 function getIsoCode(country){
   if(!country) return "xx";
   var codes=xmlISO.getElementsByTagName('cc');
   for(var i=0;i<codes.length;i++){
     var code=codes[i];
     for(var j=0;j<code.childNodes.length;j++){
       var node=code.childNodes[j];
       switch(node.nodeName){
       case 'map':
         if(country.toLowerCase()==node.firstChild.data.toLowerCase())
           return code.getAttribute('id');
       }
     }
   }
   return "un";
 }
 function format(time,f){
   if(!time) return "";
   switch(f.toLowerCase()){
   case 'h':
     var h=int(time/60);
     var m=time-h*60;
     return h+':'+(m<10?'0':'')+m+' '+hour;
   case 'm':
     return time+' '+min;
   case 's':
     return time*60+' '+sec;
   default:
     return time;
   }
 }
 function append(){
   var argv=append.arguments;
   var title="";
   for(var i=0;i<argv.length;i++){
     if(argv[i]){title+=argv[i];} else {return "";}
   }
   return title;
 }

//COOKIES MANAGEMENT
 function createCookie(name,value,days){
   if(days){
     var date=new Date();
     date.setTime(date.getTime()+(days*24*60*60*1000));
     var expires="; expires="+date.toGMTString();
   }
   else var expires="";
   document.cookie=name+"="+value+expires+"; path=/";
 }
 function readCookie(name){
   var value=name+"=";
   var ca=document.cookie.split(';');
   for(var i=0;i<ca.length;i++){
     var c=ca[i];
     while(c.charAt(0)==' ') c=c.substring(1,c.length);
     if (c.indexOf(value)==0){
       return c.substring(value.length,c.length);
     }
   }
   return null;
 }
 function eraseCookie(name){
   createCookie(name,"",-1);
 }
 function cookie(item){
   return 'pref.layout'+(item?layout.substr(6,2)+item:'');
 }

//EVENTS HANDLING
 function getEventSource(e){
   if(!e) var e=window.event;
   e.cancelBubble=true;
   if(e.stopPropagation) e.stopPropagation();
   e=e.srcElement||e.target;
   while(e.nodeName!="TD"){
     e=e.parentNode;
   }
   return e;
 }
 function hoverOn(e){
   e=getEventSource(e).parentNode;
   for(var i=0;i<e.cells.length;i++){
     e.cells[i].className='bodyhover';
   }
 }
 function hoverOff(e){
   e=getEventSource(e).parentNode;
   for(var i=0;i<e.cells.length;i++){
     e.cells[i].className='bodycontent';
   }
 }
 function mouseX(e){
   return e.pageX?e.pageX:e.clientX+(document.documentElement.scrollLeft?document.documentElement.scrollLeft:document.body.scrollLeft);
 }
 function mouseY(e){
   return e.pageY?e.pageY:e.clientY+(document.documentElement.scrollTop?document.documentElement.scrollTop:document.body.scrollTop); 
 }
 function addEvent(element,event,procedure,cursor){
   if(document.all){
     element.detachEvent('on'+event,procedure);
     element.attachEvent('on'+event,procedure);
     if(!cursor) element.style.cursor="hand";
   }else if(document.addEventListener){
     element.removeEventListener(event,procedure,false);
     element.addEventListener(event,procedure,false);
     if(!cursor) element.style.cursor="pointer";
   }
 }

//MARKER METHODS
 String.prototype.markerOn=function(){
   return this.replace(/&nbsp;<\/b>/i,"&nbsp;&nbsp;<img src='images/down.gif' width='8' height='8'></b>");
 }
 String.prototype.markerOff=function(){
   return this.replace(/&nbsp;<img.*/i,"");
 }
 String.prototype.markerSwap=function(){
   if(sortdir==true){
     return this.replace("up","down");
   }else{
     return this.replace("down","up");
   }
 }

//STRUCTURES
 function groupSet(name,setting,checked){
   this.name=name;
   this.setting=setting;
   this.checked=checked;
 }

//INITIALISATION FUNCTIONS 
 function loadXML(dynamic){
   if(document.implementation && document.implementation.createDocument){
     var mode=1;
   }else if(window.ActiveXObject){
     var mode=2;
   }else{
     alert('Your browser can\'t handle this script');
     return;
   }
   if(!dynamic){
     xmlData=loadFile(mode,database);
     xmlISO=loadFile(mode,countries);
   }
   layout=readCookie(cookie())||dynamic||layout;
   xmlDoc=loadFile(mode,layout);
   init();
 }

 function loadFile(mode,source){
   switch(mode){
     case 1: var xmlfile=document.implementation.createDocument("","",null); break;
     case 2: var xmlfile=new ActiveXObject("Microsoft.XMLDOM"); break;
     default: return null;
   }
   xmlfile.async=false;
   xmlfile.load(source);
   return xmlfile;
 }

 function init(){
   var oCell;
   var oRow=document.getElementById('oHeaders').insertRow(0);
   var nRow=xmlDoc.getElementsByTagName('row')[0];
   var nCells=nRow.getElementsByTagName('cell');
   var nOptions=xmlDoc.getElementsByTagName('options')[0];

   category=nOptions.getAttribute('category')||all;
   if(category.toLowerCase()=="all") category=all;
   pagesize=readCookie(cookie('pagesize'))||eval(nOptions.getAttribute('pagesize'))||10;
   pagesize-=0; //typecasting
   sortkey=nOptions.getAttribute('sortkey')||"";
   searchkey=nOptions.getAttribute('searchkey')||"Description";
   separator=eval(nOptions.getAttribute('separator'))||false;

   columns=0;
   sortdir=false;
   expanded=false;
   for(var j=0;j<nCells.length;j++){
     var nCell=nCells[j];
     oCell=oRow.insertCell(-1);
     oCell.className="bodycontent";
     oCell.innerHTML="<div class='boxbordercontent'><div class='boxcontent'><b>&nbsp;"+(nCell.getAttribute('title')||"")+"&nbsp;</b></div></div>";

     oCell.colSpan=nCell.getAttribute('colspan')||1;
     columns+=oCell.colSpan;
     var sortby=nCell.getAttribute('sortby');
     if(sortby){
       oCell.sort=sortby;
       if(sortby==sortkey){
         oCell.innerHTML=oCell.innerHTML.markerOn();
         column=oCell;
       }
       addEvent(oCell,'click',sortMovies);
     }
   }
   document.getElementById('pagesize').value=pagesize;
   oRow=document.getElementById('oCategories').insertRow(0);
   oCell=oRow.insertCell(0);
   oCell.className="bodycontent";
   oCell.innerHTML="<div class='boxcontent' id='oGroupSel'></div>";
   oCell=oRow.insertCell(1);
   oCell.className="bodycontent";
   oCell.colSpan=(columns-1>0?columns-1:1);
   oCell.innerHTML="<div class='boxcontent' id='oGroupName'></div>";

   makeLayouts();
   makeCategories();
   fillCategories();
   showCategories();
   readDefaults();
   clearMovies();
   showMovies();
   dToggle('oMenu',1);
   dToggle('oMovieTable',1);
   dToggle('wait',0);
 }

//CREATION FUNCTIONS
 function setLayout(format){
   if(format!=layout){
     dToggle('wait',1);
     dToggle('oMenu',0);
     dToggle('oMovieTable',0);
     dToggle('oPageControl',0);
     document.getElementById('oHeaders').deleteRow(0);
     document.getElementById('oCategories').deleteRow(0);
     createCookie(cookie(),format,expiry);
     setTimeout("loadXML('"+format+"')",0);
   }
 }

 function makeLayouts(){
   var html="<center><u>"+txt[0]+"</u></center>";
   for(var i=0;i<formats.length;i++){
     var format="layout"+(i+1)+".xml";
     var procedure="setLayout('"+format+"');";
     html+="<input type='radio' name='layouts'"+(layout==format?"checked":"")+" onclick="+procedure+">"+formats[i]+"<br>";
   }
   document.getElementById('oOptionsLayouts').innerHTML=html;
 }

 function makeCategories(){
   var html="<center><u>"+txt[1]+"</u></center>";
   var nGroups=xmlDoc.getElementsByTagName('group');

   categoryItem=[];
   for(var i=0;i<nGroups.length;i++){
     var group=nGroups[i];
     var name=group.getAttribute('name');
     var setting=group.getAttribute('setting');
     var checked=(readCookie(cookie(name))||group.getAttribute('checked'))=="true";
     categoryItem[i]=new groupSet(name,setting,checked);
     html+="<input type='checkbox' "+(checked==true?"checked":"")+" onclick='toggleChecked("+i+");showCategories();'>"+name+"<br>";
   }
   document.getElementById('oOptionsCategories').innerHTML=html;
 }

 function addCategory(name,index){
   if(!categoryList[index]) categoryList[index]=[];
   categoryList[index][categoryList[index].length]=name;
 }

 function fillCategories(){
   var elements=xmlData.getElementsByTagName('Movie');
   var tmpArray,subcat;

   movies=[];
   movies[all]=[];
   categoryList=[];
   addCategory(button1,0);
   addCategory(button2,0);
   addCategory(all,0);

   for(var i=0;i<elements.length;i++){
     for(var x=0;x<categoryItem.length;x++){
       try{
         var value=eval("elements[i]."+categoryItem[x].setting);
       }catch(err){
         value=null;
       }
       if(value){         
         subcat=value.divider().split(", ");
         var l0=false;
       }else{
         value=categoryItem[x].setting;
         var b=value.indexOf("'")+1;
         subcat=[];
         subcat[0]=bracket1+value.substr(b,value.lastIndexOf("'")-b)+bracket2;
         var l0=true;
       }
       for(var j=0;j<subcat.length;j++){
         var cat=subcat[j].trim().capitalize().spaceOut();
         if(cat!=""){
           tmpArray=movies[cat];
           if(tmpArray){
             tmpArray[tmpArray.length]=elements[i];
           }else{
             tmpArray=[];
             movies[cat]=tmpArray;
             tmpArray[0]=elements[i];
             addCategory(cat,(l0==false?x+1:0));
           }
         }
       }
     }
     movies[all][movies[all].length]=elements[i];
   }
   for(var i=1;i<categoryList.length;i++){
     categoryList[i].sort(alphabetic);
   }
 }

 function readDefaults(){
   var atts=xmlDoc.getElementsByTagName('default')[0].attributes;
   defaults=[];
   for(var i=0;i<atts.length;i++){
     var att=atts[i];
     defaults[att.name]=att.value;
   }
 }

//DISPLAY FUNCTIONS
 function showCategories(){
   var label="";
   var html="<a href=javascript:showMoviesDetails();>"+button1+"</a> ";
   html+="<a href=javascript:hideMoviesDetails();>"+button2+"</a> ";
   for(var c=2;c<categoryList[0].length;c++){
     label=categoryList[0][c];
     html+="<a href=javascript:showMovies('"+label+"');>"+label+"</a> ";
   }
   for(var i=1;i<categoryList.length;i++){
     if(categoryList[i] && categoryItem[i-1].checked==true){
       for(var c=0;c<categoryList[i].length;c++){
         label=categoryList[i][c];
         html+="<a href=javascript:showMovies('"+label+"');>"+label.spaceIn()+"</a> ";
       }
       if(html!="") html+="<br>";
     }
   }
   var obj=document.getElementById('oGroupName');
   obj.innerHTML=html;
   obj.align="center";
   obj.style.fontWeight="bold";
 }

 function clearMovies(row){
   var oList=document.getElementById('oMovieList');
   if(!row){row=0; empty=false};
   while(oList.rows.length>row) oList.deleteRow(-1);
 }
 
 function showMovies(c){
   if(c) category=c;
   document.getElementById('oGroupSel').innerHTML="<strong><center>"+category.spaceIn()+"</center></strong>";
   if(sortkey!=""){
     sortdir=!sortdir;
     sort(sortkey);
   }
   startfrom=0;
   showPage();
 }

 function showMovieDetails(e){
   e=getEventSource(e).more;
   for(var n=0;n<=letters.length;n++){
     var level=(n==0?'':letters.charAt(n-1));
     if(document.getElementById(e+level)){dToggle(e+level,-1)} else {break};
   }
 }

 function showMoviesDetails(){
   var finish=(movies[category].length-startfrom<pagesize?(movies[category].length):startfrom+pagesize);
   for(var i=startfrom;i<finish;i++){
     var e=movies[category][i].getAttribute('Number').set();
     for(var n=0;n<=letters.length;n++){
       var level=(n==0?'':letters.charAt(n-1));
       if(document.getElementById(e+level)){dToggle(e+level,1)} else {break};
     }
   }
   expanded=true;
 }
 
 function hideMoviesDetails(){
   var finish=(movies[category].length-startfrom<pagesize?(movies[category].length):startfrom+pagesize);
   for(var i=startfrom;i<finish;i++){
     var e=movies[category][i].getAttribute('Number').set();
     for(var n=0;n<=letters.length;n++){
       var level=(n==0?'':letters.charAt(n-1));
       if(document.getElementById(e+level)){dToggle(e+level,0)} else {break};
     }
   }
   expanded=false;
 }
 
 function showMoviePopup(e){
   var popup=document.getElementById('oPopup');
   popup.style.width=screen.availWidth*3/5;
   popup.style.top=e.clientY-screen.availHeight/12;
   popup.style.left=e.clientX+screen.availWidth/12;
   popup.style.display="";
   e=getEventSource(e);
   var html=["<table class='boxbordercontent' cellspacing='0'>"];
   html.push("<tr><td colspan='"+columns+"' class='bodycontent'><div class='boxbordercontent'><div class='boxcontent'><b>");
   html.push(e.innerHTML+"</b></div></div></td></tr>");
   for(var i=0;i<=letters.length;i++){
     var row=document.getElementById(e.more+(i==0?'':letters.charAt(i-1)));
     if(row){html.push("<tr>"+row.innerHTML+"</tr>")} else {break};
   }
   html.push("</table>");
   popup.innerHTML=html.join('');
   dToggle('oPopup',1);
 }

 function hideMoviePopup(e){
   document.getElementById('oPopup').innerHTML="";
   dToggle('oPopup',0);
 }
 
 function toggleMoviePopup(e){
   dToggle('oPopup',-1);
 }
 
 function showPage(){
   var oList=document.getElementById('oMovieList');
   if(movies[category].length>0){
     if(empty==true) clearMovies();
     showTitles(oList);
   }else{
     noTitles(oList);
   }
   window.scrollTo(0,0);
   showFooter();
 }

 function showTitles(oList){
   var nRows=xmlDoc.getElementsByTagName('row');
   var oRow,oCell,z=0,html=[],imageview=null;

   if(movies[category].length-startfrom<pagesize || pagesize==0){
     var finish=movies[category].length;
   }else{
     var finish=startfrom+pagesize;
   }
   for(var r=startfrom;r<finish;r++){
     rowindex=r+1;
     movie=movies[category][r];
     if(r!=startfrom && separator){
       if(z>=oList.rows.length){
         oRow=oList.insertRow(-1);
         oCell=oRow.insertCell(0);
         oCell.colSpan=columns;
         oCell.className="bodycontent";
         oCell.innerHTML="<center><div class='boxcontent'></div></center>";
       }
       z++;
     }
     for(var i=0;i<nRows.length;i++){
       var nRow=nRows[i];
       if(nRow.getAttribute('thumbnails')!="true"){
         if(z>=oList.rows.length){
           oRow=oList.insertRow(-1);
           var newRow=true;
         }else{
           oRow=oList.rows[z];
           var newRow=false;
         }
         z++;
         var atts=nRow.attributes;
         for(var n=0;n<atts.length;n++){
           var att=atts[n];
           switch(att.name){
           case 'hide' : if(expanded==false) oRow.style.display="none"; break;
           case 'id'   : oRow.id=eval(att.value); break;
           case 'hover':
             addEvent(oRow,'mouseover',hoverOn,true);
             addEvent(oRow,'mouseout',hoverOff,true);
           }
         }
         showCell(nRow,oRow,newRow);
       }else{
         var nCell=nRow.getElementsByTagName('cell')[0];
         if(oList.rows.length==0){
           oRow=oList.insertRow(-1);
           oCell=oRow.insertCell(-1);
           oCell.className="bodycontent";
           var atts=nCell.attributes;
           for(var n=0;n<atts.length;n++){
             var att=atts[n];
             switch(att.name){
             case 'colspan': oCell.colSpan=att.value; break;
             case 'align'  : oCell.align=att.value; break;
             case 'valign' : oCell.vAlign=att.value; }
           }
         }
         if(z==0) z=1;
         imageview=true;
         showImages(nCell,html);
       }
     }
   }
   if(imageview) oList.rows[0].cells[0].innerHTML=html.join('');
   clearMovies(z);
 }

 function showCell(nRow,oRow,newRow){
   var pin=nRow.getAttribute('pin')!=null;
   var popup=nRow.getAttribute('popup')!=null;
   var nCells=nRow.getElementsByTagName('cell');
   for(var i=0;i<nCells.length;i++){
     var nCell=nCells[i];
     if(newRow==true){
       oCell=oRow.insertCell(-1);
       oCell.className="bodycontent";
       var atts=nCell.attributes;
       for(var n=0;n<atts.length;n++){
         var att=atts[n];
         switch(att.name){
         case 'rowspan': oCell.rowSpan=att.value; break;
         case 'colspan': oCell.colSpan=att.value; break;
         case 'align'  : oCell.align=att.value; break;
         case 'valign' : oCell.vAlign=att.value; }
       }
     }else{
       oCell=oRow.cells[i];
     }
     if(nCell.getAttribute('pin') || pin==true){
       oCell.more=eval((pin==false?nCell:nRow).getAttribute('pin'));
       addEvent(oCell,'click',showMovieDetails);
     }else if(nCell.getAttribute('popup') || popup==true){
       oCell.more=eval((popup==false?nCell:nRow).getAttribute('popup'));
       addEvent(oCell,'mouseover',showMoviePopup);
       addEvent(oCell,'mouseout',hideMoviePopup);
       addEvent(oCell,'click',toggleMoviePopup);
     }
     var html=[];
     for(var k=0;k<nCell.childNodes.length;k++){
       var node=nCell.childNodes[k];
       switch(node.nodeName){
       case 'text':
         var text=eval(node.firstChild.data);
         if(text){
           var target="_blank",tip=null,nLink=null;
           var atts=node.attributes;
           for(var n=0;n<atts.length;n++){
             var att=atts[n];
             switch(att.name){
             case 'bold': text="<b>"+text+"</b>"; break;
             case 'italic': text="<i>"+text+"</i>"; break;
             case 'underline': text="<u>"+text+"</u>"; break;
             case 'url': nLink=eval(att.value); break;
             case 'target': target=att.value; break;
             case 'alt':
             case 'title': tip=eval(att.value); }
           }
           if(nLink){
             var href=["<a href=",nLink," target=",target];
             if(tip) href.push(" title=",tip.sanitize());
             href.push(">");
             html.push(href.join('"')+text.toString().linefeed()+"</a>");
           }else{
             html.push(text.toString().linefeed());
           }
         }
         break;
       case 'img':
         var atts=node.attributes;
         var target="_blank",image=[],nLink=null;
         for(var n=0;n<atts.length;n++){
           var att=atts[n];
           switch(att.name){
           case 'src': image.push("<img src=",eval(att.value)||defaults['image']); break;
           case 'width': image.push(" width=",att.value); break;
           case 'height': image.push(" height=",att.value); break;
           case 'url': nLink=eval(att.value); break;
           case 'target': target=att.value; break;
           case 'alt':
           case 'title': 
             tip=eval(att.value);
             if(tip) image.push(" title=",tip.sanitize());
           }
         }          
         image.push(">");
         if(nLink){
           var href=["<a href=",nLink," target=",target,">"];
           html.push(href.join('"')+image.join('"')+"</a>");
         }else{
           html.push(image.join('"'));
         }
         break;
       case 'br':
         html.push("<br>");
         break;
       case 'sp':
         html.push("&nbsp;");
         break;
       }
     }
     oCell.innerHTML=html.join('');
   }
 }

 function showImages(nCell,html){         
   for(var i=0;i<nCell.childNodes.length;i++){
     var node=nCell.childNodes[i];
     if(node.nodeName=="img"){
       var atts=node.attributes;
       var target="_blank",image=[],nLink=null;
       for(var n=0;n<atts.length;n++){
         var att=atts[n];
         switch(att.name){
         case 'src': image.push("<img src=",eval(att.value)||defaults['image']); break;
         case 'width': image.push(" width=",att.value); break;
         case 'height': image.push(" height=",att.value); break;
         case 'url': nLink=eval(att.value); break;
         case 'target': target=att.value; break;
         case 'alt':
         case 'title':
           var id=eval(att.value);
           image.push(" onmouseover=","toolTip(event,'"+id+"')");
           image.push(" onmouseout=","toolTip(event,'"+id+"')");
         }
       }
       image.push(">");
       if(nLink){
         var href=["<a href=",nLink," target=",target,">"];
         html.push(href.join('"')+image.join('"')+"</a> ");         
       }else{
         html.push(image.join('"')+" ");
       }
     }
   }
 }
 
 function noTitles(oList){ 
   clearMovies(0);
   var oCell=oList.insertRow(0).insertCell(0);
   oCell.align="center";
   oCell.className="bodycontent";
   oCell.colSpan=columns;
   oCell.style.color="red";
   oCell.innerHTML=txt[2];
   empty=true;
 }

 function showFooter(){
   if(movies[category].length>pagesize && pagesize>0){
     document.getElementById('oPagesFirst').innerHTML="<center><a href='javascript:firstPage();'>\<\<</a></center>";
     document.getElementById('oPagesBack').innerHTML ="<center><a href='javascript:previousPage();'>\<</a></center>";
     document.getElementById('oPagesInfo').innerHTML ="<strong><center>"+txt[3]+" "+currentPage()+txt[4]+totalPages()+"</center></strong>";
     document.getElementById('oPagesNext').innerHTML ="<center><a href='javascript:nextPage();'>\></a></center>";
     document.getElementById('oPagesLast').innerHTML ="<center><a href='javascript:lastPage();'>\>\></a></center>";
     dToggle('oPageControl',1)
   }else{
     dToggle('oPageControl',0);
   }
   if(isNumber(document.getElementById('oJumpTo').value)) document.getElementById('oJumpTo').value=currentPage();
 }

 function firstPage(){
   startfrom=0;
   document.getElementById('oJumpTo').value='';
   showPage();
 }

 function lastPage(){
   startfrom=(movies[category].length-pagesize>0?movies[category].length-pagesize:0);
   document.getElementById('oJumpTo').value='';
   showPage();
 }

 function nextPage(){
   startfrom+=(startfrom+pagesize<movies[category].length?pagesize:0);
   document.getElementById('oJumpTo').value='';
   showPage();
 }

 function previousPage(){
   startfrom=(startfrom-pagesize>0?startfrom-pagesize:0);
   document.getElementById('oJumpTo').value='';
   showPage();
 }

//CONTROL FUNCTIONS
 function sortMovies(e){
   e=getEventSource(e);
   if(e.sort==sortkey){
     e.innerHTML=e.innerHTML.markerSwap();
   }else{
     if(sortkey!="") column.innerHTML=column.innerHTML.markerOff();
     e.innerHTML=e.innerHTML.markerOn();
     column=e;
   }  
   sort(e.sort);
   startfrom=0;
   showPage();
 }

 function sort(k){
   var oldkey=sortkey;
   sortkey=k;
   if(sortdir==true || sortkey!=oldkey){
     sortdir=false;
     movies[category]=movies[category].sort(ascending);
   }else{
     sortdir=true;
     movies[category]=movies[category].sort(descending);
   }
 }

 function ascending(x,y){
   if(cast(x.getAttribute(sortkey))<cast(y.getAttribute(sortkey))) return -1;
   if(cast(x.getAttribute(sortkey))>cast(y.getAttribute(sortkey))) return 1;
   return 0;
 }

 function descending(x,y){
   if(cast(x.getAttribute(sortkey))>cast(y.getAttribute(sortkey))) return -1;
   if(cast(x.getAttribute(sortkey))<cast(y.getAttribute(sortkey))) return 1;
   return 0;
 }

 function alphabetic(x,y){
   if(x<y) return -1;
   if(x>y) return 1;
   return 0;
 }

 function setPagesize(){
   pagesize=int(document.getElementById('pagesize').value);
   createCookie(cookie('pagesize'),pagesize,expiry);
 }

 function toggleChecked(i){
   categoryItem[i].checked=!categoryItem[i].checked;
   createCookie(cookie(categoryItem[i].name),categoryItem[i].checked,expiry);
 }

 function search(x){
   if(x.length==0){
     showMovies(all);
   }else{
     movies[find]=[];
     var obj=new RegExp(x,"gi");
     var sArray=searchkey.split(",");
     for(var i=0;i<movies[all].length;i++){
       for (var j=0; j<sArray.length;j++){
         if(obj.test(movies[all][i].getAttribute(sArray[j]))){
           movies[find][movies[find].length]=movies[all][i];
           break;
         }
       }
     }
     showMovies(find);
   }
 }

  function jump(p){
   if(p>0 && p<=totalPages()){
     startfrom=(p-1)*pagesize;
   }else if(isLetter(p,"")){
     p=p.toUpperCase();
     for(var i=0;i<movies[category].length;i++){
       if(movies[category][i].getAttribute('FormattedTitle').charAt(0).toUpperCase()==p){
         startfrom=i;
         break;
       }
     }
     document.getElementById('oJumpTo').value=p;
   }
   showPage();
 }

  function pageDown(p){
   if(p>=1 && p<totalPages()){
     p++;
     startfrom=(p-1)*pagesize;
   }else if(isLetter(p,"Z")){
     p=chr(asc(p)+1).toUpperCase();
     for(var i=0;i<movies[category].length;i++){
       if(movies[category][i].getAttribute('FormattedTitle').charAt(0).toUpperCase()==p){
         startfrom=i;
         break;
       }
     }
     document.getElementById('oJumpTo').value=p;
   }
   showPage();
 }

 function pageUp(p){
   if(p>1 && p<=totalPages()){
     p--;
     startfrom=(p-1)*pagesize;
   }else if(isLetter(p,"A")){
     p=chr(asc(p)-1).toUpperCase();
     for(var i=0;i<movies[category].length;i++){
       if(movies[category][i].getAttribute('FormattedTitle').charAt(0).toUpperCase()==p){
         startfrom=i;
         break;
       }
     }
     document.getElementById('oJumpTo').value=p;
   }
   showPage();
 }

 function toolTip(e,img){
   var windowWidth=getWindowWidth();
   var tip=document.getElementById('oTip');
   if(oldtip && oldtip!=tip){
     oldtip.style.visibility='hidden';
   }
   if(tip.style.visibility=='visible'){
     tip.style.visibility='hidden';
   }else{
     var html=["<table cellspacing='0'>"];
     for(var n=0;n<=letters.length;n++){
       var row=document.getElementById(img+(n==0?'':letters.charAt(n-1)));
       if(row){html.push("<tr>"+row.innerHTML+"</tr>")} else {break};
     }
     html.push("</table>");
     tip.style.width=screen.availWidth/2;
     tip.innerHTML=html.join('');
     if(tip.offsetWidth){
       var w=tip.offsetWidth;
     }else if(tip.clip.width){
       var w=tip.clip.width;
     }
     var y=mouseY(e)+16;
     var x=mouseX(e)-(w/4);
     if(x<2){
       x=2;
     }else if(x+w>windowWidth){
       x=windowWidth-w-4;
     }
     tip.style.top=y+'px';    
     tip.style.left=x+'px';
     tip.style.visibility='visible';
     oldtip=tip;
   }
 }