(***************************************************

Ant Movie Catalog importation script
www.antp.be/software/moviecatalog/

[Infos]
Authors=
Title=StringUtils1.pas
Description=
Site=
Language=?
Version=
Requires=3.5.1
Comments=
License=
GetInfo=0

[Options]

***************************************************)

unit StringUtils1;

const StringUtils1_Version = 4;

{
  PLEASE READ THIS BEFORE MODIFYING THIS FILE :
  If you want to put some of your functions in an external
  file because they are common to several of your scripts,
  please create a new file your your functions
  (e.g. StringUtils2 if they are also functions to work on
  strings) rather than add them in this file.
  So each "unit" (.pas files) belong to one script creator
  and there is no risk that two people modify it at the
  same time.
}

{
  This file was created by Antoine Potten, originally
  for IMDB script.
  Of course, you can use these functions in your scripts,
  they're made for that. Simply add "StringUtils1" in the
  uses clause of your script.
}

{
  History
  -------
  v.2:  Added a version number, few minor changes in the functions,
        and the FindLine function used by lots of old scripts (they
        would all have to be modified to use this file).
  v.3:  Added FindFullLine function
}

var
  RemainingText: string;
  {
    when calling...     this variable contains...
    ------------        ----------------------
    TextBefore          the text after SearchText
    TextBetween         the text after AfterText
  }

// ***** Like the Pos function, but returns the last occurence instead of the first one *****

function LastPos(ASearch: string; AText: string): Integer;
var
  CurPos, PrevPos: Integer;
begin
  PrevPos := 0;
  CurPos := Pos(ASearch, AText);
  while CurPos > 0 do
  begin
    if PrevPos = 0 then
      PrevPos := CurPos
    else
      PrevPos := PrevPos + CurPos + Length(ASearch) - 1;
    Delete(AText, 1, CurPos + Length(ASearch) - 1);
    CurPos := Pos(ASearch, AText);
  end;
  Result := PrevPos;
end;

// *****
{    Returns the text before SearchText, but not before BeginLimit (if it is not empty),
    It takes the last occurence of BeginLimit found before the position of SearchText  }

function TextBefore(WholeText: string; SearchText: string; BeginLimit: string): string;
var
  FoundPos, PrevPos: Integer;
  WorkText: string;
begin
  RemainingText := WholeText;
  Result := '';
  FoundPos := Pos(SearchText, WholeText);
  if FoundPos = 0 then
    Exit;
  WorkText := Copy(WholeText, 1, FoundPos - 1);
  RemainingText := Copy(WholeText, FoundPos + Length(SearchText), Length(WholeText));
  if BeginLimit <> '' then
  begin
    FoundPos := LastPos(BeginLimit, WorkText);
    if FoundPos = 0 then
      Exit
    else
      FoundPos := FoundPos + Length(BeginLimit);
  end
  else
    FoundPos := 1;
  Result := Copy(WorkText, FoundPos, Length(WorkText));
end;

// ***** Returns the text after SearchText *****

function TextAfter(WholeText: string; SearchText: string): string;
var
  FoundPos: Integer;
begin
  Result := '';
  FoundPos := Pos(SearchText, WholeText);
  if FoundPos = 0 then
    Exit;
  Result := Copy(WholeText, FoundPos + Length(SearchText), Length(WholeText));
end;

// *****
{    Returns the text between BeforeText and AfterText (without these two strings),
     It takes the first AfterText occurence found after the position of BeforeText  }

function TextBetween(WholeText: string; BeforeText: string; AfterText: string): string;
var
  FoundPos: Integer;
  WorkText: string;
begin
  RemainingText := WholeText;
  Result := '';
  FoundPos := Pos(BeforeText, WholeText);
  if FoundPos = 0 then
    Exit;
  WorkText := Copy(WholeText, FoundPos + Length(BeforeText), Length(WholeText));
  FoundPos := Pos(AfterText, WorkText);
  if FoundPos = 0 then
    Exit;
  Result := Copy(WorkText, 1, FoundPos - 1);
  RemainingText := Copy(WorkText, FoundPos + Length(AfterText), Length(WorkText));
end;

// *****
{    Searches for a partial text of one of the items of a TStringList
     Returns -1 if not found   }

function FindLine(Pattern: string; List: TStringList; StartAt: Integer): Integer;
var
  i: Integer;
begin
  result := -1;
  if StartAt < 0 then
    StartAt := 0;
  for i := StartAt to List.Count-1 do
    if Pos(Pattern, List.GetString(i)) <> 0 then
    begin
      result := i;
      Break;
    end;
end;

// *****
{    Searches for a full text of one of the items of a TStringList
     Returns -1 if not found   }

function FindFullLine(Line: string; List: TStringList; StartAt: Integer): Integer;
var
  i: Integer;
begin
  result := -1;
  if StartAt < 0 then
    StartAt := 0;
  for i := StartAt to List.Count-1 do
    if Line = List.GetString(i) then
    begin
      result := i;
      Break;
    end;
end;

// *****
{    Removes tabs and linebreaks in addition of spaces on both sides of the string  }
// rewritten by dtsr

function FullTrim(Value: string): string;
var
  i, max: Integer;
  StartPos, EndPos: Integer;
begin
  max := Length(Value);
  if ((Value <= ' ') and (max < 2)) then
    Result := '' //preventing out of range condition in StrGet if i=0 in 2nd cycle
  else
  begin
    StartPos := 0;
    EndPos := max + 1;
    i := 1;
    while ((i < max) and (StrGet(Value, i) <= ' ')) do
    begin
      StartPos := i;
      i := i + 1;
    end;
    i := max;
    while ((i > StartPos) and (StrGet(Value, i) <= ' ')) do
    begin
      EndPos := i;
      i := i - 1;
    end;
    Result := Copy(Value, StartPos + 1, EndPos - StartPos - 1);
  end;
end; // *****

begin
end.
