<!-- Movie Template #2 - Created By Twink - TwinkMan666@hotmail.com      -->
<!-- Made for Ant Movie Cataglog http://www.buypin.com/moviecatalog.php  -->
<!-- Based on my old template with lots of ideas from Willspo's Template -->
<!-- Keep up the good work guys!!!                                       -->
<!-- LastUpdated: 14/11/02  Version BETA 0.8                             -->

//SYSTEM VARIABLES
 var startFrom = 0;                // Start Showing From (used for pages)
 var movies = null;                // Holds All Movies
 var movie = null;                 // Current movie
 var sortedBy;                     // Last Column Sorted By
 var lastSortedBy;                 // Last Column Sorted By
 var sortAsc = true;               // Sort Ascending/Decending
 var shownCategory = new Array();  // Array of Category Types
 var shownCategories = new Array();// Array of Categories
 var maxCols=0;
 var searchOn;

 var category = "(All)";           // Default Category to Show First (also defined in layout.xml)
 var maxPerPage = 20;              // Default PerPage (also defined in layout.xml)
 var showSeparator = true;         // Default Show Separator (also defined in layout.xml)

 var xmlDoc;					   // Variable that holds Layout.xml
 var xmlMovies;				       // Variable that holds Movies.xml


//GENERAL FUNCTIONS
 //Trim Leading and Trailing Blanks
 String.prototype.trim = function(){
   return this.replace(/(^\s*)|(\s*$)/g, "");
 }

 //Round a number to X dp
 function round(number,X) {
   return Math.round(number*Math.pow(10,X))/Math.pow(10,X);
 }

//DISPLAY FUNCTIONS

 //Wipes all Category Types
 function clearCategoryType(){
   shownCategory = new Array();
   document.getElementById('oOptionsCategories').innerHTML="Group by<br><br>";
 }

 //Add Type of Category (Letters, Genre, Format)
 function addCategoryType(Name,Variable,Checked){
    var o = shownCategory.length;
    shownCategory[o] = new shownCategoryType(Name,Variable);
    shownCategory[o].shown = Checked;
    document.getElementById('oOptionsCategories').innerHTML +=  "<input type = 'checkbox' "+(shownCategory[o].shown==true?"checked":"")+" onclick='shownCategory["+o+"].shown=!shownCategory["+o+"].shown;makeGroups();'>"+Name+"<br>";
 }

 //Clear Categories
 function clearCategories(){
   shownCategories = new Array();
 }

 //Create Actual Category (A-Z, Action/Comedy, Divx/MPEG)
 function createCategory(categoryName,level){
  if(shownCategories[level]==null)shownCategories[level] = new Array();
  shownCategories[level][shownCategories[level].length]=categoryName;
 }

 //Write Categories and Links
 function showCategories(){
  document.getElementById('oGroupNameBox').deleteCell(1);
  var oCell = document.getElementById('oGroupNameBox').insertCell(1);
  oCell.className = "bodycontent";
  oCell.colSpan = (maxCols-1>0?maxCols-1:1);
  oCell.innerHTML = "<div class = 'boxcontent' ID='oGroupName'></div>";

  var  obj =   document.getElementById('oGroupName');
  obj.innerHTML ="";
   for(var level=0;level<shownCategories.length;level++){
     if(shownCategories[level]!=null){
       shownCategories[level].sort(sortAlpha);
       for(var categoryCounter=0;categoryCounter<shownCategories[level].length;categoryCounter++){
         obj.innerHTML += "<a href=javascript:startFrom=0;category='"+shownCategories[level][categoryCounter]+"';doSort(false);showCategory();>"+shownCategories[level][categoryCounter]+"</a>&nbsp;";
       }
       if (obj.innerHTML!=""&&level!=0)obj.innerHTML+="<br>";
     }

   }
   obj.align = "center";
   obj.style.fontWeight = "Bold";
 }

 //Wipe All Movies From Display (called when swapping Category/Page)
 function clearMovies(){
   var ML =  document.getElementById('oMovieList');
   while(ML.rows.length>0){
    ML.deleteRow(0);
   }
 }

 //Show Hide Object
 function dToggle(objectName,show){
 	
   if (show==-1&&document.getElementById(objectName).style.display==""||show==0)
     document.getElementById(objectName).style.display = "none";
   else document.getElementById(objectName).style.display = "";
 }


 //Reads Movies into Array Sorting into Categories
 function makeGroups() {
   hideSort();

   movies  = new Array();
   var catArray = null;
   var cArray = null;
   var temp;
   var category = "";
   clearCategories();

   var  elements = xmlMovies.getElementsByTagName('Movie');

   movies["(All)"] = new Array();
   createCategory("(All)",0);
   for (var i = 0; i < elements.length; i++) {
     for(var x =0;x<shownCategory.length;x++){
       if(shownCategory[x].shown==true){
         try{
           var value = eval("elements[i]." + shownCategory[x].Variable);
         } catch(er){value="";}
         temp = " / " + (value!=null?value:"(None)");
         cArray = new String(temp).split(" / ");
         for (var j = 0; j < cArray.length;j++){
           category = cArray[j].trim();
           category = category.charAt(0).toUpperCase()+category.substring(1,category.length);
           category = category.replace(/\s/g,"_");

           if (category != null && category != "" && category != "undefined") {
             catArray = movies[category];
             if (catArray == null) {
               catArray = new Array();
               movies[category] = catArray;
               catArray[0] = elements[i];
               createCategory(category,(category!="(None)"?x+1:0));
             } else {
               catArray[catArray.length] = elements[i];
             }
           }
         }
       }
     }
     movies["(All)"][movies["(All)"].length] = elements[i];
   }

   if(sortedBy!="")doSort(false);
   showCategories();
   showCategory();
 }

 function init(){
   var  nRow = xmlDoc.getElementsByTagName('row')[0];

   if(document.getElementById('oMovieList').rows.length>0) document.getElementById('oHeaders').deleteRow(0);
   maxCols=0;
   var oRow = document.getElementById('oHeaders').insertRow(0);
   var nCells = nRow.getElementsByTagName("cell");
   for(var j=0;j<nCells.length;j++){
     var oCell = oRow.insertCell(oRow.cells.length);
     oCell.className = "bodycontent";
     oCell.innerHTML = "<div class = 'boxbordercontent'>   <div class = 'boxcontent'> <b>&nbsp;"+(nCells[j].getAttribute('title')==null?"":nCells[j].getAttribute('title'))+"&nbsp;</b> </div> </div>";
     if(nCells[j].getAttribute('colspan')!=null) oCell.colSpan = nCells[j].getAttribute('colspan');
     maxCols+=oCell.colSpan;

     if(nCells[j].getAttribute('sortby')!=null){
       oCell.style.cursor = "hand";
       if (document.all)
         oCell.attachEvent('onclick', eventSortBy);
       else if (document.addEventListener)
         oCell.addEventListener('click', eventSortBy, true);
       oCell.text = nCells[j].getAttribute('id');
       oCell.sort = nCells[j].getAttribute('sortby');
     }
   }

   var  nOptions = xmlDoc.getElementsByTagName('options')[0];
   if(nOptions.getAttribute('perpage')!=null)  MaxPerPage = eval(nOptions.getAttribute('perpage'));
   if(nOptions.getAttribute('category')!=null) category = nOptions.getAttribute('category');
   if(nOptions.getAttribute('showseparator')!=null) showSeparator = eval(nOptions.getAttribute('showseparator'));
   if(nOptions.getAttribute('sorton')!=null)sortedby=nOptions.getAttribute('sorton');
   if(nOptions.getAttribute('searchon')!=null) searchon = nOptions.getAttribute('searchon');


   clearCategoryType();
   var  nGroups = xmlDoc.getElementsByTagName('group');
   for(var j=0;j<nGroups.length;j++){
     addCategoryType(nGroups[j].getAttribute('name'),nGroups[j].getAttribute('setting'),(nGroups[j].getAttribute('checked')==null?false:true));
   }

   var obj = document.getElementById('oPerpage');
   obj.value = maxPerPage;

   makeGroups();
 }

 function loadXML(){
   xmlDoc = loadFile(xmlLayout);
   xmlMovies = loadFile(xmlMovies);
   var  nRow = xmlDoc.getElementsByTagName('row');
   init();
 }

 function loadFile(filename){
  var xmlfile;
  if (document.implementation && document.implementation.createDocument){
		xmlfile = document.implementation.createDocument("", "", null);
	//	xmlfile.onload = display;
	}else if (window.ActiveXObject){
		xmlfile = new ActiveXObject("Microsoft.XMLDOM");
		//xmlfile.onreadystatechange = displayIE;
 	 }else{
	   alert('Your browser can\'t handle this script');
   	 return;
   }

  xmlfile.async = true;
  xmlfile.load(filename);

//  while(xmlfile.readyState != 4)alert(xmlfile.readyState);

  return xmlfile;
 }

/*  var xmlMovies = new ActiveXObject("MSXML2.DOMDocument.4.0");


  	if (document.implementation && document.implementation.createDocument){
		xmlMovies = document.implementation.createDocument("", "", null);

	}else if (window.ActiveXObject){
		xmlMovies = new ActiveXObject("Microsoft.XMLDOM");
  }

  xmlMovies.async = true;

  xmlMovies.load("movies.xml");*/

 function displayIE(){
   if (xmlDoc.readyState == 4)   init();
 }

 function display(){
   init();
 }

 //Loop Through Movie[category] and Show each movie
 function showCategory(){
   if(movies[category]==null) category = "(All)";
   document.getElementById('oGroupSel').innerHTML = "<STRONG><CENTER>"+category+"<CENTER></STRONG>";
   clearMovies();

   endAt=((movies[category].length-startFrom)<maxPerPage?(movies[category].length):maxPerPage+startFrom);
   if(MaxPerPage<1) EndAt = movies[category].length;

   if(movies[category].length==0||startFrom==endAt){
      oRow = document.getElementById('oMovieList').insertRow(document.getElementById('oMovieList').rows.length);
      oCell = oRow.insertCell(0);
      oCell.align = "center";
      oCell.className = "bodycontent";
      oCell.innerHTML = "No Movies to Display<br>";
      oCell.colSpan=maxCols;
   } else {
     for(var i = startFrom; i<endAt;i++){
       if(i!=startFrom&&showSeparator){
         oRow = document.getElementById('oMovieList').insertRow(document.getElementById('oMovieList').rows.length);
         oCell=oRow.insertCell(oRow.cells.length);
         oCell.colSpan=maxCols;
         oCell.className = "bodycontent";
         oCell.innerHTML =  "<center><div class = 'boxcontent'></div></center>";
       }
       showMovie(i);
     }
   }


  document.getElementById('oPages').deleteCell(1);
  var oCell = document.getElementById('oPages').insertCell(1);
  oCell.innerHTML = "<div class = 'boxbordercontent'><div class = 'boxcontent' ID = 'oPagesMid'></div></div>"
  oCell.className = "bodycontent";
  oCell.colSpan = ((maxCols-2)>0?(maxCols-2):1);

   if(movies[category].length>maxPerPage&&maxPerPage>0){
     document.getElementById('oPagesBack').innerHTML = "<CENTER><a href='javascript:startFrom="+(startFrom-maxPerPage>0?startFrom-maxPerPage:0)+";showCategory();'>Back</a></CENTER>";
     document.getElementById('oPagesMid').innerHTML = "<STRONG><CENTER>Page: " + round((startFrom/maxPerPage)+1,0) + " of " + round((movies[category].length/maxPerPage)+1,0) + "</CENTER></STRONG>";
     document.getElementById('oPagesNext').innerHTML = "<CENTER><a href='javascript:startFrom="+(startFrom+maxPerPage<movies[category].length?startFrom+maxPerPage:startFrom)+";showCategory();'>Next</a></CENTER";
   }else{
     document.getElementById('oPagesBack').innerHTML = "";
     document.getElementById('oPagesMid').innerHTML = "";
     document.getElementById('oPagesNext').innerHTML = "";
   }



   dToggle('oMovieTable',1);
   dToggle('oWait',0);
 }


function showMovie(num){
  var oRow;
  var oCell;
  var temp;
  var MovieNum = num;

  movie = movies[category][MovieNum];
  var  nRows = xmlDoc.getElementsByTagName('row');

  for(var i = 0;i<nRows.length;i++){
     oRow = document.getElementById('oMovieList').insertRow(document.getElementById('oMovieList').rows.length);
     if(nRows[i].getAttribute('hidden')=="true") oRow.style.display = "none";
     if(nRows[i].getAttribute('id')!=null) oRow.id = eval(nRows[i].getAttribute('id'));

     var nCells = nRows[i].getElementsByTagName("cell");
     for(var j=0;j<nCells.length;j++){
       oCell = oRow.insertCell(oRow.cells.length);
       oCell.className = "bodycontent";
       var HTML ="";

       if(nCells[j].getAttribute('rowspan')!=null) oCell.rowSpan = nCells[j].getAttribute('rowspan');
       if(nCells[j].getAttribute('colspan')!=null) oCell.colSpan = nCells[j].getAttribute('colspan');
       if(nCells[j].getAttribute('align')!=null) oCell.align = nCells[j].getAttribute('align');
       if(nCells[j].getAttribute('valign')!=null) oCell.vAlign = nCells[j].getAttribute('valign');
       if(nCells[j].getAttribute('popuptitle')!=null) oCell.popuptitle = eval(nCells[j].getAttribute('popuptitle'));

       if(nCells[j].getAttribute('action')!=null){
        oCell.style.cursor = "hand";
        if (document.all)
          oCell.attachEvent('onclick', eventShowDetails);
        else if (document.addEventListener)
          oCell.addEventListener('click', eventShowDetails, true);
        oCell.toggle = eval(nCells[j].getAttribute('action'));
       }

       if(nCells[j].getAttribute('popup')!=null){
        oCell.style.cursor = "hand";
        if (document.all)
          oCell.attachEvent('onclick', eventShowPopup);
        else if (document.addEventListener)
          oCell.addEventListener('click', eventShowPopup, true);
        oCell.popup = eval(nCells[j].getAttribute('popup'));
       }        

       if(nCells[j].getAttribute('mouseover')!=null){
        oCell.style.cursor = "hand";
        if (document.all)
          oCell.attachEvent('onmouseover', eventMouseOver);
        else if (document.addEventListener)
          oCell.addEventListener('mouseover', eventMouseOver, true);          
        oCell.mouseover = nCells[j].getAttribute('mouseover');
       }
       
       if(nCells[j].getAttribute('mouseout')!=null){
        oCell.style.cursor = "hand";
        if (document.all)
          oCell.attachEvent('onmouseout', eventMouseOut);
        else if (document.addEventListener)
          oCell.addEventListener('mouseout', eventMouseOut, true);          
        oCell.mouseout = nCells[j].getAttribute('mouseout');
       }       


       for(var k=0;k<nCells[j].childNodes.length;k++){
        var node = nCells[j].childNodes[k];
        var type = node.nodeName;


         if(type == "img"){
           if (node.getAttribute('url')!=null) HTML +=  "<a href = '"+eval(node.getAttribute('url'))+"' target='"+(node.getAttribute('target')==null?"":node.getAttribute('target'))+"'>";
           HTML += "<img src='"+eval(node.getAttribute('src')) +"'";
           if (node.getAttribute('width')!=null) HTML +=  " width='"+node.getAttribute('width')+"'";
           if (node.getAttribute('height')!=null) HTML +=  " height='"+node.getAttribute('height')+"'";
           if (node.getAttribute('class')!=null) HTML +=  " class='"+node.getAttribute('class')+"'";
           HTML += ">";
           if (node.getAttribute('url')!=null) HTML +=  "</a>";
         }

         if(type == "br"){
           HTML +="<br>";
         }

         if(type == "sp"){
           HTML +="&nbsp;";
         }

         if(type == "text"){
           if (node.getAttribute('url')!=null) HTML +=  "<a href = '"+eval(node.getAttribute('url'))+"' target='"+(node.getAttribute('target')==null?"":node.getAttribute('target'))+"'>";
           if (node.getAttribute('bold')=="true") HTML += "<b>";
           if(eval(node.getAttribute('value'))!=null)HTML += String(eval(node.getAttribute('value'))).replace(/\|/g,"<br>");
           HTML+="&nbsp;";
           if (node.getAttribute('bold')=="true") HTML += "</b>";
           if (node.getAttribute('url')!=null) HTML +=  "</a>";
         }

         if(type == "div"){
           HTML+="<div id='"+eval(node.getAttribute('id'))+"' class='"+node.getAttribute('class')+"'></div>";
         }

       }
       oCell.innerHTML = HTML;
       if(nCells[j].getAttribute('debug')!=null){
         oCell = oRow.insertCell(oRow.cells.length);
         oCell.className = "bodycontent";
         oCell.innerText = HTML;
       }
     }

  }
}


//STRUCTS
 function shownCategoryType(Name,Variable){
   this.Name = Name;
   this.Variable = Variable;
   this.shown = false;
 }

//BOOKMARK
 function BookMark(X){
   if(movies["(BookMarked)"]==null){
     createCategory("(BookMarked)",0);
     movies["(BookMarked)"] = new Array();
   }

   movies["(BookMarked)"][movies["(BookMarked)"].length]=movies[category][X];

   showCategories();
 }

//EVENTS
 //Returns object that triggered event
 function getEventObject(eventObject){
 	if(document.all){
     eventObject=eventObject.srcElement;
     while(eventObject.nodeName != "TD")
     	eventObject = eventObject.parentNode;
  } else eventObject=this;

  return eventObject;
 }
 
 function eventMouseOver(eventObject){
 	eventObject = getEventObject(eventObject);
 	 	
    eventObject = eventObject.parentNode;
    
    for(var i=0;i<eventObject.cells.length;i++){
    	eventObject.cells[i].className = eventObject.cells[i].mouseover;
    }
    
 	
 	
 }

 function eventMouseOut(eventObject){
 	eventObject = getEventObject(eventObject); 	
 	 

     	eventObject = eventObject.parentNode;
 	 for(var i=0;i<eventObject.cells.length;i++){
    	eventObject.cells[i].className = eventObject.cells[i].mouseout;
    } 	
 }

 //Triggered on Column Title clicked.  Runs sort.
 function eventSortBy(eventObject){
   eventObject = getEventObject(eventObject);

   if(lastSortedBy!=eventObject)hideSort();

   sortedby=eventObject.sort;
   doSort(lastSortedBy==eventObject);
   lastSortedBy=eventObject;

   showSort(eventObject);
   showCategory();
 }

 //Displays the Popup info
 function eventShowPopup(eventObject){
  eventObject = getEventObject(eventObject);

  var popup = document.getElementById("oPopup");
  popup.style.width= screen.availWidth / 2;
  popup.style.height= screen.availHeight / 2;
  var posX = screen.availWidth / 4 ;
  var posY = screen.availHeight / 4;
  popup.style.posTop = posY;
  popup.style.posLeft = posX;

  var HTML = "<table class= 'boxbordercontent' cellspacing='0'>";
  if(eventObject.popuptitle!="")HTML += "<tr><td colspan='5' class='bodycontent'><div class = 'boxbordercontent'><div class = 'boxcontent'><b>"+eventObject.popuptitle+"</b></div></div></td></tr>";
  HTML += document.getElementById(eventObject.popup).innerHTML
  HTML += "<tr><td class='bodycontent' colspan='4'><a  href ='javascript:dToggle(&quot;oPopup&quot;,0);' class='button'>Close</a></tr></td>";
  HTML += "</table>";
  popup.innerHTML = HTML;
  dToggle("oPopup",1);
 }


 //Toggles Extra Movie Details
 function eventShowDetails(eventObject){
  eventObject = getEventObject(eventObject);
  eventObject=eventObject.toggle;

  cArray = new String(eventObject).split(";");
  for (var j = 0; j < cArray.length;j++){
    dToggle(cArray[j],-1);
  }
 }

//SORT FUNCTIONS

  //Hides the sort triangle
  function hideSort(){
   if(lastSortedBy!=null){
     var HTML = "<div class = 'boxbordercontent'><div class = 'boxcontent'><b>&nbsp;";
     HTML += lastSortedBy.text;
     HTML += "</b> </div></div>";
     lastSortedBy.innerHTML = HTML;
   }
  }

  //Displays the sort triangle
  function showSort(column){
   var HTML = "<div class = 'boxbordercontent'><div class = 'boxcontent'><b>&nbsp;";
   HTML += column.text;
   HTML += "&nbsp;<img src='pics//"+(sortAsc!=true?"down":"up")+".png' width='8' height='8'>";
   HTML += "</b> </div></div>";
   column.innerHTML = HTML;
  }

 //Calls sort() or revSort()
 function doSort(sameColumn){
   if(sameColumn==false||sameColumn==true&&sortAsc==false){
     movies[category] = movies[category].sort(sort);
     sortAsc=true;
   } else {
     movies[category] = movies[category].sort(revSort);
     sortAsc=false;
   }
 }

 //Picks Text or Numerical Sort
 function sort(X,Y){
   var value1 = eval("X.getAttribute('"+sortedby+"')");
   var value2 = eval("Y.getAttribute('"+sortedby+"')");

   if(!isNumeric(value1)||!isNumeric(value2)){
     return sortAlpha(value1,value2);
   } else {
     return sortNumerical(value1,value2);
   }
 }

 //Text Sort
 function sortAlpha(firstWord,secondWord){
   if(firstWord<secondWord)return -1;
   if(firstWord>secondWord)return 1;
   return 0;
 }

 //Numerical Sort
 function sortNumerical(firstNumber,secondNumber){
   return firstNumber-secondNumber;
 }

 //Calls sort with parameters reversed
 function revSort(firstItem,secondItem){
    return sort(secondItem,firstItem);
 }

 //Checks if String is Numerical
 function isNumeric(sText){
   if (sText==null)return true;
   var validChars = "0123456789.";
   var isNumber=true;
   var char;

   for (i = 0; i < sText.length && isNumber == true; i++){
     char = sText.charAt(i);
     if (validChars.indexOf(char) == -1){
         isNumber = false;
     }
   }
   return isNumber;
 }

//FIND
 function search(X){

   if(movies["(Search)"]==null) createCategory("(Search)",0);
   movies["(Search)"] = new Array();
   var v_regexp = new RegExp(X,"gi");

   var cArray = new String(searchon).split(";");
   if (cArray.length==0)return;


   for(var i = 0;i<movies["(All)"].length;i++){
     var show=false;
     for (var j = 0; j < cArray.length;j++){
       if(eval("v_regexp.test(movies['(All)'][i].getAttribute('"+cArray[j]+"'))")) show=true;
     }

     if(show==true)
         movies["(Search)"][movies["(Search)"].length] = movies["(All)"][i];
   }

   showCategories();
   category="(Search)";
   startFrom = 0;
   showCategory();
 }