var processor = null;
var sortOrder = "ascending";
var params = new Array();
var isReady = true;

function loadSource(sourceObj) {
	var xmlDoc = new ActiveXObject("MSXML2.FreeThreadedDOMDocument.3.0");
    xmlDoc.async=false;
    xmlDoc.load(sourceObj.XMLDocument);
    return xmlDoc;
}

function getProcessor(transformObj) {
	if (processor == null){
    	var xslDoc = new ActiveXObject("MSXML2.FreeThreadedDOMDocument.3.0");
        var xslTemplate = new ActiveXObject("MSXML2.XSLTemplate.3.0");
        xslDoc.async = false;
        xslDoc.load(transformObj.XMLDocument);
        xslTemplate.stylesheet = xslDoc;
        xslProcessor = xslTemplate.createProcessor();
        table_proc = xslProcessor;
	} else {
        xslProcessor=processor;
    }
    return xslProcessor;
}

/** 
 * Tranforms the xml source data with the XSLT with the 
 * parameters defines by the global variable params
 */
function transformData() {
	var srcDoc = loadSource(moviesXML);
	var processor = getProcessor(transformXML);
	var resultDoc = new ActiveXObject("MSXML.DOMDocument");
	var paramIterator = new Enumerator(params);
	processor.input=srcDoc;
   	processor.output=resultDoc;
	
	while (!paramIterator.atEnd()) {
		processor.addParameter(paramIterator.item().key, paramIterator.item().value);
		paramIterator.moveNext();
	}
  	 	processor.transform();
	
	return resultDoc;   
}

function Param(key, value) {
	this.key = key;
	this.value = value;
}

function addParam(key, value) {
	var newParam = new Param(key, value);
	params[key] = newParam;
}

function sortBy(value) {
	if (!isReady) return;
	sortOrder = (sortOrder == "ascending") ? "descending" : "ascending";
	addParam("sort_by", value);
	addParam("sort_data_type", "text");
	addParam("sort_order", sortOrder);
	resultDoc = transformData();		
	document.all.main.filters[0].apply();
	hideMovieInfo();
	document.all.main.innerHTML = resultDoc.xml;
	document.all.main.filters[0].play();
}

function showCategory(category){
	if (!isReady) return;
	var main = document.all.main;
	addParam("selected_category", category);
	resultDoc = transformData();		
	main.filters[0].apply();
	hideMovieInfo();
	main.innerHTML = resultDoc.xml;
	main.filters[0].play();
}

function showMovieInfo(movieNumber) {
	if (!isReady) return;
	var infoView = document.all.infoView;
	addParam("movie_number", movieNumber);
	addParam("mode", "info_view");
	resultDoc = transformData();
	infoView.filters[0].apply();
	if (infoView.style.visibility == "hidden" || infoView.style.visibility == 0) {
		infoView.style.visibility = "visible";
	}
	infoView.innerHTML = resultDoc.xml;
	infoView.filters[0].play();
	addParam("mode", "normal_view");
}

function hideMovieInfo() {
	if (!isReady) return;
	document.all.infoView.style.visibility = "hidden";
}

function search(string) {
	if (!isReady) return;
	var main = document.all.main;
	addParam("search", "true");
	addParam("search_string", string.toLowerCase());
	showCategory('All');
	addParam("search", "false");		
}

function mouseOverTR(trObj) {
	trObj.className = "movieListSelected";
}    

function mouseOutTR(trObj) {
	trObj.className = "movieList";
}