<?php

session_start();

/**
 * main.php
 *
 * displays the main frame
 *
 * changes:
 *	- 07 Aug 03: initial version
 *	- 08 Aug 03: sort and language strings added
 *	- 12 Aug 03: language change at runtime now possible
 *	- 13 Aug 03: new sort setting: starting with a number
 *	- 20 Aug 03: dutch language added
 *	- 22 Aug 03: stats added (category percentages)
 *	- 02 Sep 03: new stat added (country + filter)
 *	- 22 Oct 03: actor report added; multigenre support added
 *	- 23 Oct 03: additional fields added to details page
 *	- 28 Oct 03: directors report added, title handling slightly changed, subtitles added
 *	- 10 Nov 03: content linking added
 */

require('parser.php');
include('settings.php');

if (isset($_GET['language']))
{
	$_SESSION['currentLanguage'] = $_GET['language'];
}
include('language_'.$_SESSION['currentLanguage'].'.php');

// parse the file (in case it has not been done already)
if (!isset($_SESSION['movieList'])) {
    $result=parseFile();
}

// function to fill empty fields in rows with blanks (looks better)
function fillin($text)
{
	if($text == '')
	{
		return '&nbsp';
	} else
	{
		return $text;
	}
}

// function to replace the seperators in cast list
function createCastList($text)
{
	if ($_SESSION['ContentLinking'] == true)
	{
		if($_SESSION['ActorsSeparator'] == "imdb")
		{
			$temparray = explode("),",$text); 
			for($x=0;$x<count($temparray);$x++)
			{
				if($temparray[$x]!='')
				{
					if(strpos($temparray[$x], "(") != false)
					{
						$actor = substr($temparray[$x], 0, strpos($temparray[$x], "("));
					} else
					{
						$actor = $temparray[$x];
					}
					$temparray[$x] = "<a href=\"main.php?page=2&offset=0&field=all&filter=".trim($actor)."\" target=\"main\">".trim($actor)."</a> ".substr($temparray[$x], strpos($temparray[$x], "(")).")";
				}
			}
			$actorstring = implode(", ", $temparray);
			return substr($actorstring, 0, strlen($actorstring)-1);
		} else
		{
			$temparray = explode($_SESSION['ActorsSeparator'],$text); 
			for($x=0;$x<count($temparray);$x++)
			{
				if($temparray[$x]!='')
				{
					$temparray[$x] = "<a href=\"main.php?page=2&offset=0&field=all&filter=".trim($temparray[$x])."\" target=\"main\">".trim($temparray[$x])."</a>";
				}
			}
			$actorstring = implode($_SESSION['ActorsSeparator']." ", $temparray);
			return $actorstring;
		}
	} else
	{
		$replace = array ("\x7c" => "<br>");
		return strtr($text, $replace);
	}
}

function createDirectorList($text)
{
	if ($_SESSION['ContentLinking'] == true)
	{
		$temparray = explode(",",$text); 
		for($x=0;$x<count($temparray);$x++)
		{
			if($temparray[$x]!='')
			{
				$temparray[$x] = "<a href=\"main.php?page=2&offset=0&field=all&filter=".trim($temparray[$x])."\" target=\"main\">".trim($temparray[$x])."</a>";
			}
		}
	return implode(", ", $temparray);
	} else
	{
		return $text;
	}

}

function formatLinebreaks($text)
{
	$replace = array ("\x7c" => "<br>");
	return strtr($text, $replace);	
}

// function to sort the search list
function sortSearchList($a, $b) 
{
	if ($a[$_SESSION['orderSearchListBy']] == $b[$_SESSION['orderSearchListBy']])
	{
		return ($a['movieNumber'] < $b['movieNumber']) ? -1 : 1;
	}

	if ($_SESSION['orderSearchListDirection'] == 'asc')
	{
		return ($a[$_SESSION['orderSearchListBy']] < $b[$_SESSION['orderSearchListBy']]) ? -1 : 1;
	} else
	{
		return ($a[$_SESSION['orderSearchListBy']] > $b[$_SESSION['orderSearchListBy']]) ? -1 : 1;
	}
}

// function to sort the main list
function sortMovieList($a, $b) 
{
	if ($a[$_SESSION['orderListBy']] == $b[$_SESSION['orderListBy']])
	{
		return ($a['movieNumber'] < $b['movieNumber']) ? -1 : 1;
	}

	if ($_SESSION['orderListDirection'] == 'asc')
	{
		return ($a[$_SESSION['orderListBy']] < $b[$_SESSION['orderListBy']]) ? -1 : 1;
	} else
	{
		return ($a[$_SESSION['orderListBy']] > $b[$_SESSION['orderListBy']]) ? -1 : 1;
	}
}

// displays the stars for the rating
function displayRating($rating)
{
	for ($i=1;$i<=$rating;$i++)
	{
		print "<img src=\"gfx/goldstar.gif\" alt=\"rating\" border=\"0\">";
	}
	while($i<=10)
	{
		print "<img src=\"gfx/greystar.gif\" alt=\"rating\" border=\"0\">";
		$i++;
	}
}

// check current language
function checklanguage($lang)
{
	if ($_SESSION['currentLanguage'] == $lang)
	{
		return ' selected';
	} else
	{
		return '';
	}
}

// add onLoad Javascript
function moreOnLoad()
{
	if (isset($_GET['language']))
	{
		return "parent.frames.search.location.href='search.php';parent.frames.categories.location.href='categories.php';";
	}
}

// set key sort for stats
function setKeySort($stat)
{
	if ($_GET[$stat] == 'keyd')
	{
		return 'keya';
	} else 
	{
		return 'keyd';
	}
}

// set value sort for stats
function setValSort($stat)
{
	if ($_GET[$stat] == 'vald')
	{
		return 'vala';
	} else 
	{
		return 'vald';
	}
}

// set n/a for empty fields
function checkNA($field)
{
	if ($field == '')
	{
		return res_NA;
	} else
	{
		return $field;
	}
}

/////////////////////////////////////////////////////////////////////
// main html creation
/////////////////////////////////////////////////////////////////////

// first the html header (+ javascript for row-highlighting)
// todo: remove non-called scripts
?>
<html>
<head>
<script language="javascript">
<!--

function changeMyColour(cellID) 
{
	document.all(cellID).style.background = '#EEEEEE'
	document.all(cellID).style.cursor = 'hand'
}
	
function changeMyColour_back(cellID) 
{
	document.all(cellID).style.background = '#FFFFFF'
}
	
/* ------------ rows ---------- */
function crossRow_over(rowID,colID) 
{
	row = rowID;
	col = colID;
	for (c = 1; c <= col; c++) 
	{
		CellID = "r"+row+"c"+c
	  	changeMyColour(CellID)
	}
}
	
function crossRow_out(rowID,colID) 
{
	row = rowID;
	col = colID;
	for (c = 1; c <= col; c++) 
	{
		CellID = "r"+row+"c"+c
	  	changeMyColour_back(CellID)
	}
}
	
/* ------------ columns ---------- */
function crossCol_over(rowID,colID) 
{
	row = rowID;
	col = colID;
	for (r = 1; r <= row; r++) 
	{
		CellID = "r"+r+"c"+col
	  	changeMyColour(CellID)
	}
}
	
function crossCol_out(rowID,colID) 
{
	row = rowID;
	col = colID;
	for (r = 1; r <= row; r++) 
	{
		CellID = "r"+r+"c"+col
	  	changeMyColour_back(CellID)
	}
}
	
/* ------------ all---------- */
function crossAll(rowID,colID) 
{
	row = rowID;
	col = colID;
	for (r = 1; r <= row; r++) 
	{
	  	for (c = 1; c <= col; c++) 
		{
	   		CellID = "r"+r+"c"+c
	   		changeMyColour(CellID)
	  	}
	}
}
	
function crossAll_out(rowID,colID) 
{
	row = rowID;
	col = colID;
	for (r = 1; r <= row; r++) 
	{
		for (c = 1; c <= col; c++) 
		{
	   		CellID = "r"+r+"c"+c
	   		changeMyColour_back(CellID)
	  	}
	}
}

//-->
</script>
<link rel="stylesheet" type="text/css" href="css/styles.css">	
</head>
<?php
print "<body onLoad=\"parent.frames.navi.location.href='navigation.php';".moreOnLoad()."return true;\" bgcolor=\"#FFFFFF\">\n";

if ($_GET['page'] == 1)	// page=1 means list all
{
	// set the current page and check for a possible offset
	$_SESSION['currentSubPage'] = 1;
	if (isset($_GET['offset']))
	{
		$_SESSION['currentOffset'] = $_GET['offset'];
	}
	
	if ($_GET['sort'] != '')
	{
		$_SESSION['orderListBy'] = $_GET['sort'];
	}

	if ($_GET['direct'] != '')
	{
		$_SESSION['orderListDirection'] = $_GET['direct'];
	}

	// sort the list
	uasort($_SESSION['movieList'], sortMovieList);

	// fill the table header
	$row = 1;
	print "\t<table align=\"center\" border=\"1\" cellpadding=\"1\" cellspacing=\"0\" rules=\"rows\" frame=\"hsides\">\n";
	print "\t\t<tr bgcolor=\"#00D0FF\">\n\t\t\t";
	print "<td id=\"r".$row."c1\" width=\"35\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieNumber&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">#</a></div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c2\" width=\"300\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movie".$_SESSION['usedTitle']."&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_TITLE."</a></div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c3\" width=\"200\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieDirector&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_DIRECTOR."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c4\" width=\"100\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieCountry&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_COUNTRY."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c5\" width=\"150\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieCategory&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_CATEGORY."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c6\" width=\"40\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieYear&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_YEAR."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c7\" width=\"25\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieLength&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_LENGTH."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c8\" width=\"25\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=1&offset=0&sort=movieRating&direct=";
	print (($_SESSION['orderListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_RATING."</div>\n\t\t\t</td>\n\t\t</tr>";
	$row++;
	
	// display the list		
	$rowcount = 1;
	foreach($_SESSION['movieList'] as $arr)
	{
		// start at offset
		// todo: fast direct jump possible ???
		if ($row > $_SESSION['currentOffset']+1) 
		{
			// check if rowlimit per page is reached
			if ($rowCount >= $_SESSION['entriesPerPage'])
			{
			  break;
			}
			$rowCount++;
			
			// todo: class="relative" ntig ???
			print "\n\t\t<tr id=\"r".$row."\" onclick=\"parent.frames.main.location.href='main.php?page=3&movieID=";
			print $arr["movieNumber"]."';return true;\" onmouseover=\"crossRow_over($row,8)\" onmouseout=\"crossRow_out($row,8)\">\n\t\t\t";
			print "<td id=\"r".$row."c1\" class=\"relative\"><div class=\"row\"><b>";
			print fillin($arr["movieNumber"])."</b></div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c2\" class=\"relative\"><div class=\"row\">";
			print $arr["movie".$_SESSION['usedTitle']]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c3\" class=\"relative\"><div class=\"row\">";
			print fillin($arr["movieDirector"])."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c4\" class=\"relative\"><div class=\"row\">";
			print $arr["movieCountry"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c5\" class=\"relative\"><div class=\"row\">";
			print $arr["movieCategory"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c6\" class=\"relative\"><div class=\"row\">";
			print $arr["movieYear"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c7\" class=\"relative\"><div class=\"row\" align=\"center\">";
			print $arr["movieLength"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c8\" class=\"relative\"><div class=\"row\" align=\"center\">";
			print $arr["movieRating"]."</div>\n\t\t\t</td>\n\t\t";
			print "</tr>";
		}
		$row++;
	}
	print "\n\t</table><br>";

	// display list navigation
	print "\n\t<table align=\"center\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\">\n\t\t";
	print "<tr>\n\t\t\t<td width=\"25\" align=\"center\"><a href=\"main.php?page=1&offset=0\" target=\"main\"> << </a>\n\t\t\t</td>";
	print "<td width=\"25\" align=\"center\"><a href=\"main.php?page=1&offset=";
	if (($_SESSION['currentOffset']-$_SESSION['entriesPerPage']) > 0)
	{
		print ($_SESSION['currentOffset']-$_SESSION['entriesPerPage']);
	} else
	{
		print "0";
	}
	print "\" target=\"main\"> < </a>\n\t\t\t</td>";
	$currentPage = ceil($_SESSION['currentOffset']/$_SESSION['entriesPerPage'])+1;
	print "<td width=\"150\" align=\"center\"> ".res_PAGE." ".$currentPage." / ".ceil(count($_SESSION['movieList'])/$_SESSION['entriesPerPage'])." \n\t\t\t</td>";
	print "<td width=\"25\" align=\"center\"><a href=\"main.php?page=1&offset=";
	if (($_SESSION['currentOffset']+$_SESSION['entriesPerPage']) < count($_SESSION['movieList']))
	{
		print ($_SESSION['currentOffset']+$_SESSION['entriesPerPage']);
	} else
	{
		print $_GET['offset'];
	}
	print "\" target=\"main\"> > </a>\n\t\t\t</td>";
	print "<td width=\"25\" align=\"center\"><a href=\"main.php?page=1&offset=";
	print (count($_SESSION['movieList'])-$_SESSION['entriesPerPage']);
	print "\" target=\"main\"> >> </a>\n\t\t\t</td>\n\t\t</tr>\n\t</table>\n";
	print "</html>";
}

if ($_GET['page'] == 2) // page=2 means search results
{
	// todo: GETs prfen, nicht jedes mal neu searchen, auf andere fields erweitern

	$_SESSION['currentSubPage'] = 2;
	if (isset($_GET['offset']))
	{
		$_SESSION['currentOffsetSearch'] = $_GET['offset'];
	}
	
	if ($_GET['sort'] != '')
	{
		$_SESSION['orderSearchListBy'] = $_GET['sort'];
	}

	if ($_GET['direct'] != '')
	{
		$_SESSION['orderSearchListDirection'] = $_GET['direct'];
	}
	
	// category filter was set
	if ($_GET['field'] == 'category') 
	{
	    $_SESSION['searchList'] = array();
		foreach	($_SESSION['movieList'] as $arr)
		{
			if($_SESSION["Multigenre"] == true)
			{
				if (strstr(strtolower($arr["movieCategory"]),strtolower($_GET['filter'])) != false)
				{
					$_SESSION['searchList'][] = $arr;
				}
			} else
			{
				if($arr["movieCategory"] == $_GET['filter'])
				{
					$_SESSION['searchList'][] = $arr;
				}
			}
		}
	}

	// country filter was set
	if ($_GET['field'] == 'country') 
	{
	    $_SESSION['searchList'] = array();
		foreach	($_SESSION['movieList'] as $arr)
		{
			if($arr["movieCountry"] == $_GET['filter'])
			{
				$_SESSION['searchList'][] = $arr;
			}
		}
	}
	
	// year filter was set
	if ($_GET['field'] == 'year') 
	{
	    $_SESSION['searchList'] = array();
		foreach	($_SESSION['movieList'] as $arr)
		{
			if($arr["movieYear"] == $_GET['filter'])
			{
				$_SESSION['searchList'][] = $arr;
			}
		}
	}

	// letter filter was set
	if ($_GET['field'] == 'letter')
	{
		$_SESSION['searchList'] = array();
		foreach	($_SESSION['movieList'] as $arr)
		{
			if ($_GET['filter'] == '1')
			{
				if ((ord(substr($arr["movie".$_SESSION['usedTitle']],0,1)) >= ord('0')) and (ord(substr($arr["movie".$_SESSION['usedTitle']],0,1)) <= ord('9')))
				{
					$_SESSION['searchList'][] = $arr;
				}
			
			} else
			{
				if (strtolower(substr($arr["movie".$_SESSION['usedTitle']],0,1)) == $_GET['filter'])
				{
					$_SESSION['searchList'][] = $arr;
				}
			}
		}
	}

	// search filter was set
	if ($_GET['field'] == 'all')
	{
		$_SESSION['searchList'] = array();
		foreach	($_SESSION['movieList'] as $arr)
		{
			if((strstr(strtolower($arr["movie".$_SESSION['usedTitle']]),strtolower($_GET['filter'])) != false) or (strstr(strtolower($arr["movieDirector"]),strtolower($_GET['filter'])) != false) or (strstr(strtolower($arr["movieActors"]),strtolower($_GET['filter'])) != false))
			{
				$_SESSION['searchList'][] = $arr;
			}
		}				
	}

	// no matching result
	if (count($_SESSION['searchList']) == 0)
	{
		print "\t<div class=\"normaltext\">".res_NOSEARCHRESULTS."</div>\n</body>\n</html>";
		exit;
	} else
	{
		print "\t<div class=\"normaltext\">".count($_SESSION["searchList"])." ".res_RESULTSFOUND."</div>";
	}

	// sort the result list
	uasort($_SESSION['searchList'], sortSearchList);

	// fill the table header
	$row = 1;
	print "\t<table align=\"center\" border=\"1\" cellpadding=\"1\" cellspacing=\"0\" rules=\"rows\" frame=\"hsides\">\n";
	print "\t\t<tr bgcolor=\"#00D0FF\">\n\t\t\t";
	print "<td id=\"r".$row."c1\" width=\"35\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieNumber&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">#</a></div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c2\" width=\"300\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movie".$_SESSION['usedTitle']."&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_TITLE."</a></div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c3\" width=\"200\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieDirector&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_DIRECTOR."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c4\" width=\"100\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieCountry&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_COUNTRY."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c5\" width=\"150\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieCategory&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_CATEGORY."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c6\" width=\"40\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieYear&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_YEAR."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c7\" width=\"25\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieLength&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_LENGTH."</div>\n\t\t\t</td>";
	print "<td id=\"r".$row."c8\" width=\"25\"><div class=\"head\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=2&offset=0&sort=movieRating&direct=";
	print (($_SESSION['orderSearchListDirection'] == 'asc') ? 'desc' : 'asc');
	print "\" target=\"main\">".res_RATING."</div>\n\t\t\t</td>\n\t\t</tr>";
	$row++;
	
	// display the list		
	$rowcount = 1;
	foreach($_SESSION['searchList'] as $arr)
	{
		// start at offset
		// todo: fast direct jump possible ???
		if ($row > $_SESSION['currentOffsetSearch']+1) 
		{
			// check if rowlimit per page is reached
			if ($rowCount >= $_SESSION['entriesPerPage'])
			{
			  break;
			}
			$rowCount++;
			
			// todo: class="relative" ntig ???
			print "\n\t\t<tr id=\"r".$row."\" onclick=\"parent.frames.main.location.href='main.php?page=3&movieID=";
			print $arr["movieNumber"]."';return true;\" onmouseover=\"crossRow_over($row,8)\" onmouseout=\"crossRow_out($row,8)\">\n\t\t\t";
			print "<td id=\"r".$row."c1\" class=\"relative\"><div class=\"row\"><b>";
			print fillin($arr["movieNumber"])."</b></div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c2\" class=\"relative\"><div class=\"row\">";
			print $arr["movie".$_SESSION['usedTitle']]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c3\" class=\"relative\"><div class=\"row\">";
			print fillin($arr["movieDirector"])."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c4\" class=\"relative\"><div class=\"row\">";
			print $arr["movieCountry"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c5\" class=\"relative\"><div class=\"row\">";
			print $arr["movieCategory"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c6\" class=\"relative\"><div class=\"row\">";
			print $arr["movieYear"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c7\" class=\"relative\"><div class=\"row\" align=\"center\">";
			print $arr["movieLength"]."</div>\n\t\t\t</td>\n\t\t\t";
			print "<td id=\"r".$row."c8\" class=\"relative\"><div class=\"row\" align=\"center\">";
			print $arr["movieRating"]."</div>\n\t\t\t</td>\n\t\t";
			print "</tr>";
		}
		$row++;
	}
	print "\n\t</table><br>";

	// display list navigation
	print "\n\t<table align=\"center\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\">\n\t\t";
	print "<tr>\n\t\t\t<td width=\"25\" align=\"center\"><a href=\"main.php?page=2&offset=0\" target=\"main\"> << </a>\n\t\t\t</td>";
	print "<td width=\"25\" align=\"center\"><a href=\"main.php?page=2&offset=";
	if (($_SESSION['currentOffsetSearch']-$_SESSION['entriesPerPage']) > 0)
	{
		print ($_SESSION['currentOffsetSearch']-$_SESSION['entriesPerPage']);
	} else
	{
		print "0";
	}
	print "\" target=\"main\"> < </a>\n\t\t\t</td>";
	$currentPage = ceil($_SESSION['currentOffsetSearch']/$_SESSION['entriesPerPage'])+1;
	print "<td width=\"150\" align=\"center\"> ".res_PAGE." ".$currentPage." / ".ceil(count($_SESSION['searchList'])/$_SESSION['entriesPerPage'])." \n\t\t\t</td>";
	print "<td width=\"25\" align=\"center\"><a href=\"main.php?page=2&offset=";
	if (($_SESSION['currentOffsetSearch']+$_SESSION['entriesPerPage']) < count($_SESSION['searchList']))
	{
		print ($_SESSION['currentOffsetSearch']+$_SESSION['entriesPerPage']);
	} else
	{
		print $_GET['offset'];
	}
	print "\" target=\"main\"> > </a>\n\t\t\t</td>";
	print "<td width=\"25\" align=\"center\"><a href=\"main.php?page=2&offset=";
	print (count($_SESSION['searchList'])-$_SESSION['entriesPerPage']);
	print "\" target=\"main\"> >> </a>\n\t\t\t</td>\n\t\t</tr>\n\t</table>\n";
	print "</html>";
}

if ($_GET['page'] == 3) // page=3 means details
{
	$_SESSION['currentSubPage'] = 3;

	if (($_SESSION['currentDetail'] == '') and ($_GET['movieID'] == ''))
	{
		print "\t<div class=\"normaltext\">".res_NOMOVIESELECTED."</div>\n</body>\n</html>";
	} else
	{
		// todo: check for isset
		if ($_GET['movieID'] != '')
		{
			$_SESSION['currentDetail'] = $_GET['movieID'];
		}
		// todo: direct select instead of loop !!!
		foreach($_SESSION['movieList'] as $arr)
		{
			if($arr["movieNumber"] == $_SESSION['currentDetail'])
			{
				// not displayed: $arr["movieMediaLabel"], $arr["movieChecked"]
				print "\t<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" style=\"float:left; margin-right:10px; margin-bottom:6px\">\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td><img src=\"".rawurlencode($arr["moviePicture"])."\" alt=\"".$arr["movieOriginalTitle"]."\" border=\"0\">\n\t\t\t</td>\n\t\t</tr>\n\t</table>";
				print "\n\t<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n\t\t<tr>\n\t\t\t<td colspan=\"2\"><div class=\"normaltext\"><b>#".$arr["movieNumber"]." - ".$arr["movie".$_SESSION['usedTitle']]." (".$arr["movieYear"].")";
				if (($_SESSION['usedTitle'] == 'OriginalTitle') and ($arr["movieTranslatedTitle"] != ''))
				{
					print "<br>(".$arr["movieTranslatedTitle"].")";
				}
				else if (($_SESSION['usedTitle'] == 'TranslatedTitle') and ($arr["movieOriginalTitle"] != ''))
				{
					print "<br>(".$arr["movieOriginalTitle"].")";
				}
				print "\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr>\n\t\t\t<td colspan=\"2\">";
				print displayRating($arr["movieRating"])."</b></div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr>\n\t\t\t<td colspan=\"2\"><div class=\"normaltext\">".$arr["movieCategory"]." / ".$arr["movieCountry"]." (runtime:".$arr["movieLength"]." min)</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td><div class=\"normaltext\">".res_DIRECTEDBY.":\n\t\t\t</div></td>\n\t\t\t<td><div class=\"normaltext\">".createDirectorList($arr["movieDirector"])."</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr>\n\t\t\t<td valign=\"top\"><div class=\"normaltext\">".res_CAST.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"normaltext\">".formatLinebreaks(createCastList($arr["movieActors"]))."</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td valign=\"top\"><div class=\"normaltext\">".res_DESCRIPTION.":</div>\n\t\t</td>\n\t\t\t<td><div class=\"normaltext\">".checkNA($arr["movieDescription"])."</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr>\n\t\t\t<td><div class=\"normaltext\">Website:</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"normaltext\"><a href=\"".$arr["movieURL"]."\" target=\"_blank\">".$arr["movieURL"]."</a></div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td valign=\"top\"><div class=\"normaltext\">".res_COMMENTS.":</div>\n\t\t</td>\n\t\t\t<td><div class=\"normaltext\">".checkNA(formatLinebreaks($arr["movieComments"]))."</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr>\n\t\t\t<td><div class=\"normaltext\">".res_TECHNICALINFORMATION.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"normaltext\">".$arr["movieDisks"]." CDs (".$arr["movieSize"]."MB) - ".$arr["movieResolution"]."@".$arr["movieFramerate"]."fps<br>Video: ".$arr["movieVideoFormat"]."@".$arr["movieVideoBitrate"]." kBit/s<br>Audio: ".$arr["movieAudioFormat"]."@".$arr["movieAudioBitrate"]." kBit/s</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td><div class=\"normaltext\">".res_LANGUAGE.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"normaltext\">".$arr["movieLanguages"];
				if ($arr["movieSubtitles"] != "")
				{
					print "<br>(".res_SUBS.": ".$arr["movieSubtitles"].")";
				}
				print "</div>\n\t\t\t</td>\n\t\t</tr>";
				print "\n\t\t<tr>\n\t\t\t<td><div class=\"normaltext\">".res_ADDED.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"normaltext\">".$arr["movieDate"]."</div>";
				if ($arr["movieBorrower"] != "")
				{
					print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td><div class=\"normaltext\">".res_STATUS.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"normaltext\" style=\"font-weight:bold\">".res_LENT."</div>\n\t\t\t</td>\n\t\t</tr>";
				}
				print "\n\t</table>";
			}
		}
	}
	print "\n</body>";
}

if ($_GET['page'] == 4) // page=4 means statistics
{
	// todo: more stats
	$_SESSION['currentSubPage'] = 4;
	$statCat = array();
	$statCountry = array();
	$statYear = array();

	print "\t<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td width=\"200\"><div class=\"row\">".res_MOVIES.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"row\">".count($_SESSION['movieList'])."</div>\n\t\t\t</td>";
	print "\n\t\t<tr bgcolor=\"#FFFFFF\">\n\t\t\t<td><div class=\"row\">".res_CATEGORIES.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"row\">".count($_SESSION['categoryList'])."</div>\n\t\t\t</td>";	
	foreach($_SESSION['movieList'] as $arr)
	{
		$runtimeSum = $runtimeSum + $arr["movieLength"];
		if ($_SESSION["Multigenre"] == true)
		{
			$temparray = explode($_SESSION['MultigenreSeparator'],$arr["movieCategory"]);
			for($x=0;$x<count($temparray);$x++)
			{
				if(rtrim($temparray[$x]) != '')
				{
					$statCat[trim($temparray[$x])]++;
				}
			}
			
		} else
		{
			$statCat[$arr["movieCategory"]]++;
		}
		$statCountry[$arr["movieCountry"]]++;
		$statYear[$arr["movieYear"]]++;
	}
	print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td><div class=\"row\">".res_COMPLETERUNTIME.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"row\">";
	printf ('%02d hour(s) %02d minute(s)', $runtimeSum / 60, $runtimeSum % 60);
	print "</div>\n\t\t\t</td>\n\t\t</tr>";
	print "\n\t\t<tr bgcolor=\"#FFFFFF\">\n\t\t\t<td><div class=\"row\">".res_AVERAGERUNTIME.":</div>\n\t\t\t</td>\n\t\t\t<td><div class=\"row\">";
	print round(($runtimeSum/count($_SESSION['movieList'])),1);
	print " min</div>\n\t\t\t</td>\n\t\t</tr>";
	print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td colspan=\"2\" align=\"center\"><div class=\"row\"><a href=\"actors_report.php\" target=\"_blank\">".res_GENERATEACTORSREPORT."</a></div>\n\t\t\t</td>\n\t\t</tr>";
	print "\n\t\t<tr>\n\t\t\t<td colspan=\"2\" align=\"center\"><div class=\"row\"><a href=\"directors_report.php\" target=\"_blank\">".res_GENERATEDIRECTORSREPORT."</a></div>\n\t\t\t</td>\n\t\t</tr>";
	print "\n\t\t<tr bgcolor=\"#EFEFEF\">\n\t\t\t<td colspan=\"2\" align=\"center\"><div class=\"row\"><a href=\"history_report.php\" target=\"_blank\">".res_GENERATEHISTORYREPORT."</a></div>\n\t\t\t</td>\n\t\t</tr>";
	print "\n\t</table>";

	// Category table
	print "\n\t<br>\n\t<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	print "\n\t\t<tr bgcolor=\"#00D0FF\">\n\t\t\t<td><div class=\"head\" align=\"center\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=4&CatStats=".setKeySort('CatStats')."\" target=\"main\">".res_CATEGORY."</a></div>\n\t\t\t</td>\n\t\t\t<td width=\"400\"><div class=\"head\" align=\"center\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=4&CatStats=".setValSort('CatStats')."\" target=\"main\">".res_PERCENTAGE."</a></div>\n\t\t\t</td>\n\t\t</tr>";
	$row = 1;
	if (isset($_GET['CatStats']))
	{
		if ($_GET['CatStats'] == 'vala')
		{
			arsort($statCat);
			
		} else if ($_GET['CatStats'] == 'vald')
		{
			asort($statCat);
		} else if ($_GET['CatStats'] == 'keya')
		{
			krsort($statCat);
		} else if ($_GET['CatStats'] == 'keyd')
		{
			ksort($statCat);
		}
	} else
	{
		arsort($statCat);
	}
	reset($statCat);
	for ($counter=1;$counter<=count($statCat);$counter++)
	{
		$percentage = round((100*current($statCat))/(count($_SESSION['movieList'])));
		print "\n\t\t<tr ";
		if ($row%2 == 1)
		{
			print "bgcolor=\"#EFEFEF\"";
		}
		print ">\n\t\t\t<td><div class=\"row\"><a href=\"main.php?page=2&field=category&filter=".key($statCat)."&offset=0\" target=\"main\">".key($statCat)."</a></div>\n\t\t\t</td>\n\t\t\t<td valign=\"center\"><div class=\"row\"><img src=\"gfx/bar.gif\" alt=\"".key($statCat)."\" border=\"0\" height=\"15\" width=\"".(4*$percentage)."\" align=\"left\"> ".($percentage)."%</div>\n\t\t\t</td>\n\t\t</tr>";
		$row++;
		next($statCat);
	}
	print "\n\t</table>";

	// Country table
	print "\n\t<br>\n\t<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	print "\n\t\t<tr bgcolor=\"#00D0FF\">\n\t\t\t<td><div class=\"head\" align=\"center\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=4&CountryStats=".setKeySort('CountryStats')."#Country\" target=\"main\">".res_COUNTRY."</a></div>\n\t\t\t</td>\n\t\t\t<td width=\"400\"><div class=\"head\" align=\"center\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=4&CountryStats=".setValSort('CountryStats')."#Country\" target=\"main\">".res_PERCENTAGE."</a></div>\n\t\t\t</td>\n\t\t</tr>";
	$row = 1;
	if (isset($_GET['CountryStats']))
	{
		if ($_GET['CountryStats'] == 'vala')
		{
			arsort($statCountry);
			
		} else if ($_GET['CountryStats'] == 'vald')
		{
			asort($statCountry);
		} else if ($_GET['CountryStats'] == 'keya')
		{
			krsort($statCountry);
		} else if ($_GET['CountryStats'] == 'keyd')
		{
			ksort($statCountry);
		}
	} else
	{
		arsort($statCountry);
	}
	reset($statCountry);
	for ($counter=1;$counter<=count($statCountry);$counter++)
	{
		$percentage = round((100*current($statCountry))/(count($_SESSION['movieList'])));
		print "\n\t\t<tr ";
		if ($row%2 == 1)
		{
			print "bgcolor=\"#EFEFEF\"";
		}
		print ">\n\t\t\t<td><div class=\"row\"><a href=\"main.php?page=2&field=country&filter=".key($statCountry)."&offset=0\">".key($statCountry)."</a></div>\n\t\t\t</td>\n\t\t\t<td valign=\"center\"><div class=\"row\"><img src=\"gfx/bar.gif\" alt=\"".key($statCountry)."\" border=\"0\" height=\"15\" width=\"".(4*$percentage)."\" align=\"left\"> ".($percentage)."%</div>\n\t\t\t</td>\n\t\t</tr>";
		$row++;
		next($statCountry);
	}
	print "\n\t</table><a name=\"Country\"></a>";

	// Year table
	print "\n\t<br>\n\t<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	print "\n\t\t<tr bgcolor=\"#00D0FF\">\n\t\t\t<td><div class=\"head\" align=\"center\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=4&YearStats=".setKeySort('YearStats')."#Year\" target=\"main\">".res_YEAR."</a></div>\n\t\t\t</td>\n\t\t\t<td width=\"400\"><div class=\"head\" align=\"center\"><a title=\"".res_CLICKTOCHANGESORT."\" href=\"main.php?page=4&YearStats=".setValSort('YearStats')."#Year\" target=\"main\">".res_PERCENTAGE."</a></div>\n\t\t\t</td>\n\t\t</tr>";
	$row = 1;
	if (isset($_GET['YearStats']))
	{
		if ($_GET['YearStats'] == 'vala')
		{
			arsort($statYear);
			
		} else if ($_GET['YearStats'] == 'vald')
		{
			asort($statYear);
		} else if ($_GET['YearStats'] == 'keya')
		{
			krsort($statYear);
		} else if ($_GET['YearStats'] == 'keyd')
		{
			ksort($statYear);
		}
	} else
	{
		arsort($statYear);
	}
	reset($statYear);
	for ($counter=1;$counter<=count($statYear);$counter++)
	{
		$percentage = round((100*current($statYear))/(count($_SESSION['movieList'])));
		print "\n\t\t<tr ";
		if ($row%2 == 1)
		{
			print "bgcolor=\"#EFEFEF\"";
		}
		print ">\n\t\t\t<td><div class=\"row\"><a href=\"main.php?page=2&field=year&filter=".key($statYear)."&offset=0\">".key($statYear)."</a></div>\n\t\t\t</td>\n\t\t\t<td valign=\"center\"><div class=\"row\"><img src=\"gfx/bar.gif\" alt=\"".key($statYear)."\" border=\"0\" height=\"15\" width=\"".(4*$percentage)."\" align=\"left\"> ".($percentage)."%</div>\n\t\t\t</td>\n\t\t</tr>";
		$row++;
		next($statYear);
	}
	print "\n\t</table><a name=\"Year\"></a>";

	print "\n</body>\n</html>";
}

if ($_GET['page'] == 5) // page=5 means options
{
	$_SESSION['currentSubPage'] = 5;
	// todo: check negative values due to changes !!!
	if (isset($_GET['entriesPage']))
	{
		$_SESSION['entriesPerPage'] = $_GET['entriesPage'];
	}

	print "\t<form action=\"main.php\" method=\"GET\" target=\"_self\">";
	print "\n\t\t<input type=\"hidden\" name=\"page\" value=\"5\">";
	print "\n\t\t".res_LANGUAGE.": <select name=\"language\" size=\"1\">";
	print "\n\t\t\t<option value=\"english\"".checklanguage('english').">english</option>\n\t\t\t<option value=\"deutsch\"".checklanguage('deutsch').">deutsch</option>\n\t\t\t<option value=\"dutch\"".checklanguage('dutch').">dutch</option>\n\t\t\t<option value=\"spanish\"".checklanguage('spanish').">spanish</option>\n\t\t\t<option value=\"slovenian\"".checklanguage('slovenian').">slovenian</option>\n\t\t\t<option value=\"french\"".checklanguage('french').">french</option>\n\t\t</select><br>";
	print "\n\t\t".res_ROWSPERPAGE.": <input type=\"Text\" name=\"entriesPage\" value=\"".$_SESSION['entriesPerPage']."\" size=\"5\" maxlength=\"5\"><br>";
	print "\n\t\t<input type=\"Submit\" name=\"submitChanges\" value=\"".res_UPDATE."\">\n\t</form>";
	if($_SESSION["Multigenre"]==true)
	{
		print "\n\t".res_MULTIPLEGENREACTIVE;
	}

	// todo: recalc offsets and catch rows>complete list

	print "\n\t<br><br><br><div class=\"smalltext\">".$_SESSION['Version']."</div>\n</body>\n</html>";
}
?>