<?php

session_start();

/**
 * parser.php
 *
 * used to parse the xml file
 *
 * changes:
 *	- 07 Aug 03: initial version
 *	- 13 Aug 03: support usedTitle setting added
 *	- 26 Aug 03: Borrower added
 *	- 22 Oct 03: Multigenre support added
 *	- 23 Oct 03: various Fields added (Description, Framerate, AudioFormat, Audio-/Videobitrate)
 *	- 28 Oct 03: Original/Translated Title handling changed, subtitles added
 */

// element for parsing
$currentElement="";

// the xml file created by AMC
$xmlSource="MovieCatalog.xml";

// the data of each movie
$movieNumber="";
$movieMediaLabel="";
$movieBorrower="";
$movieDate="";
$movieRating="";
$movieOriginalTitle="";
$movieTranslatedTitle="";
$movieDirector="";
$movieCountry="";
$movieCategory="";
$movieYear="";
$movieLength="";
$movieActors="";
$movieURL="";
$movieDescription="";
$movieComments="";
$movieVideoFormat="";
$movieVideoBitrate="";
$movieAudioFormat="";
$movieAudioBitrate="";
$movieResolution="";
$movieFramerate="";
$movieLanguages="";
$movieSubtitles="";
$movieSize="";
$movieDisks="";
$moviePicture="";
$movieChecked="";

// array used for processing the xml
$elements=array('movieNumber',
		'movieMediaLabel',
		'movieBorrower',
		'movieDate',
		'movieRating',
		'movieOriginalTitle',
		'movieTranslatedTitle',
		'movieDirector',
		'movieCountry',
		'movieCategory',
		'movieYear',
		'movieLength',
		'movieActors',
		'movieURL',
		'movieDescription',
		'movieComments',
		'movieVideoFormat',
		'movieVideoBitrate',
		'movieAudioFormat',
		'movieAudioBitrate',
		'movieResolution',
		'movieFramerate',
		'movieLanguages',
		'movieSubtitles',
		'movieSize',
		'movieDisks',
		'moviePicture', 
		'movieChecked'); 

// will hold movie list
$movies = array();

// will hold category list
$categories = array();

/**
 * startElement handler
 */
function startElement($parser,$name,$attr)
{
	global $currentElement;
	
	$currentElement=$name;	
	
	//read all attributes
	if(strcmp($name,"Movie")==0)
	{
		$GLOBALS['movieNumber']=$attr["Number"];
		$GLOBALS['movieMediaLabel']=$attr["MediaLabel"];
		$GLOBALS['movieBorrower']=$attr["Borrower"];
		$GLOBALS['movieDate']=$attr["Date"];
		$GLOBALS['movieRating']=$attr["Rating"];
		//$GLOBALS['movieOriginalTitle']=$attr[$_SESSION['usedTitle']];
		$GLOBALS['movieOriginalTitle']=$attr["OriginalTitle"];
		$GLOBALS['movieTranslatedTitle']=$attr["TranslatedTitle"];
		$GLOBALS['movieDirector']=$attr["Director"];
		$GLOBALS['movieCountry']=$attr["Country"];
		$GLOBALS['movieCategory']=$attr["Category"];
		$GLOBALS['movieYear']=$attr["Year"];
		$GLOBALS['movieLength']=$attr["Length"];
		$GLOBALS['movieActors']=$attr["Actors"];
		$GLOBALS['movieURL']=$attr["URL"];
		$GLOBALS['movieDescription']=$attr["Description"];
		$GLOBALS['movieComments']=$attr['Comments'];
		$GLOBALS['movieVideoFormat']=$attr["VideoFormat"];
		$GLOBALS['movieVideoBitrate']=$attr["VideoBitrate"];
		$GLOBALS['movieAudioFormat']=$attr["AudioFormat"];
		$GLOBALS['movieAudioBitrate']=$attr["AudioBitrate"];
		$GLOBALS['movieResolution']=$attr["Resolution"];
		$GLOBALS['movieFramerate']=$attr["Framerate"];
		$GLOBALS['movieLanguages']=$attr["Languages"];
		$GLOBALS['movieSubtitles']=$attr["Subtitles"];		
		$GLOBALS['movieSize']=$attr["Size"];
		$GLOBALS['movieDisks']=$attr["Disks"];
		$GLOBALS['moviePicture']=$attr["Picture"];
		$GLOBALS['movieChecked']=$attr["Checked"];
	}
}

/**
 * endElement handler
 */
function endElement($parser,$name)
{    
	global $elements, $movies, $categories;

	$temp; // will hold one movie's data

	if(strcmp($name,"Movie")==0)
	{
		foreach($elements as $element)
		{
			$temp[$element]=$GLOBALS[$element];

			// fill the category list
			if ($element == 'movieCategory') 
			{
				if($_SESSION["Multigenre"] == false)
				{
			    		if (!array_search($GLOBALS[$element],$GLOBALS['categories'])) 
					{
				        	$GLOBALS['categories'][]=$GLOBALS[$element];
				    	}
				} else
				{
					$temparray = explode($_SESSION['MultigenreSeparator'],$GLOBALS[$element]);
					for($x=0;$x<count($temparray);$x++)
					{
						if(rtrim($temparray[$x]) != '')
						{
							$GLOBALS['categories'][]=trim($temparray[$x]);
						}
					}
				}
			}
		}
		$GLOBALS['movies'][]=$temp;
	}

}

/**
 * characterData handler
 */
function characterData($parser, $data) 
{
	global $elements;     

        foreach ($elements as $element) 
	{
            if ($GLOBALS["currentElement"] == $element) 
			{
                $GLOBALS[$element] .= $data;
            }
        }
}
	
/**
 * parse function	
 */
function parseFile(){
	global $xmlSource,$movies, $categories;
	
	/*Creating the xml parser*/
	$xml_parser=xml_parser_create();
	
	/*Register the handlers*/
	xml_set_element_handler($xml_parser,"startElement","endElement");
	xml_set_character_data_handler($xml_parser,"characterData");
	
	/*Disables case-folding. Needed for this example*/
	xml_parser_set_option($xml_parser,XML_OPTION_CASE_FOLDING,false);
	
	/*Open the xml file and feed it to the parser in 4k blocks*/
   	if(!($fp=fopen($xmlSource,"r")))
	{
      	  die("Cannot open  $xmlSource  ");
   	}
   	while(($data=fread($fp,4096)))
	{
    	if(!xml_parse($xml_parser,$data,feof($fp)))
		{
	     	die(sprintf("XML error at line %d column %d ", 
                      xml_get_current_line_number($xml_parser), 
                      xml_get_current_column_number($xml_parser)));
	  	}
   	}
     
	/*Finish ! we free the parser and returns the array*/
	xml_parser_free($xml_parser);
	
	// make sure categories are unique and sort them
	$categories = array_unique($categories);
	asort($categories);
	
	$_SESSION['categoryList'] = $categories;
	$_SESSION['movieList'] = $movies;
	
	return true;
}
?>