<?php

session_start();

/**
 * settings.php
 *
 * a few initial settings and configurable options
 *
 * options:
 * 	- $_SESSION['entriesPerPage'] : number of rows per list page (default: 15)
 *	- sort settings (see comment)
 *	- $_SESSION['currentLanguage'] : default language
 *
 * changes:
 *	- 07 Aug 03: initial version
 *	- 08 Aug 03: sort settings and version string added
 *	- 12 Aug 03: language setting added
 *	- 13 Aug 03: usedTitle setting added
 *	- 22 Oct 03: Multigenre settings added
 *	- 23 Oct 03: ActorsSeparator setting added
 *	- 10 Nov 03: ContentLinking setting added
 *
 */

if (!isset($_SESSION['currentOffset']))
{
	$_SESSION['currentOffset'] = 0;
}

if (!isset($_SESSION['currentOffsetSearch']))
{
	$_SESSION['currentOffsetSearch'] = 0;
}

if (!isset($_SESSION['entriesPerPage']))
{
	$_SESSION['entriesPerPage'] = 15;	// change this for more/less rows per page
}

if (!isset($_SESSION['currentSubPage'])) 
{
	$_SESSION['currentSubPage'] = 1;
}

/****************** change the default sort settings
/**
 * settings:
 * $_SESSION['orderListBy'] and $_SESSION['orderSearchListBy']
 * possible values are:
 * 	'movieNumber'
 * 	'movieOriginalTitle'
 * 	'movieDirector'
 * 	'movieCountry'
 * 	'movieCategory'
 * 	'movieYear'
 * 	'movieLength'
 * 	'movieRating'
 * $_SESSION['orderListDirection'] and $_SESSION['orderSearchListDirection']
 * possible values are (ascending or descending):
 * 	'asc'
 *	'desc'
 */
if (!isset($_SESSION['orderListBy'])) 
{
	$_SESSION['orderListBy'] = 'movieNumber';
}

if (!isset($_SESSION['orderListDirection'])) 
{
	$_SESSION['orderListDirection'] = 'asc';
}

if (!isset($_SESSION['orderSearchListBy'])) {
	$_SESSION['orderSearchListBy'] = 'movieOriginalTitle';
}

if (!isset($_SESSION['orderSearchListDirection'])) 
{
	$_SESSION['orderSearchListDirection'] = 'asc';
}
// ****************** end sort settings

if (!isset($_SESSION['currentLanguage']))
{
	$_SESSION['currentLanguage'] = 'english'; // currently allowed: 'english', 'deutsch' plus various others
}

if (!isset($_SESSION['usedTitle']))
{
	$_SESSION['usedTitle'] = 'OriginalTitle'; // currently allowed: 'OriginalTitle', 'TranslatedTitle'
}

if (!isset($_SESSION['Multigenre'])) {
	$_SESSION['Multigenre'] = false;
}

if (!isset($_SESSION['MultigenreSeparator'])) {
	$_SESSION['MultigenreSeparator'] = "/";
}

// use "imdb" for imdb-style lists (Actor1 (as role name), Actor2 (as role name), etc.)
// or any seperator character you use ("," or "/" or "\x7c")
if (!isset($_SESSION['ActorsSeparator'])) {
	$_SESSION['ActorsSeparator'] = "\x7c";	
	//$_SESSION['ActorsSeparator'] = "imdb";	
}

// content linking, NOTE: you need to set ActorsSeparator as well!
if (!isset($_SESSION['ContentLinking'])) {
	$_SESSION['ContentLinking'] = false;	
}

if (!isset($_SESSION['Version'])) {
	$_SESSION['Version'] = 'AMCphp 1.0 (24 Feb 2004)';
}
?>